<a id="plugins.aea-cli-ipfs.aea_cli_ipfs.exceptions"></a>

# plugins.aea-cli-ipfs.aea`_`cli`_`ipfs.exceptions

Module to contain exceptions for ipfs plugin.

<a id="plugins.aea-cli-ipfs.aea_cli_ipfs.exceptions.BaseIPFSToolException"></a>

## BaseIPFSToolException Objects

```python
class BaseIPFSToolException(Exception)
```

Base ipfs tool exception.

<a id="plugins.aea-cli-ipfs.aea_cli_ipfs.exceptions.RemoveError"></a>

## RemoveError Objects

```python
class RemoveError(BaseIPFSToolException)
```

Exception on remove.

<a id="plugins.aea-cli-ipfs.aea_cli_ipfs.exceptions.PinError"></a>

## PinError Objects

```python
class PinError(BaseIPFSToolException)
```

Exception on pin.

<a id="plugins.aea-cli-ipfs.aea_cli_ipfs.exceptions.PublishError"></a>

## PublishError Objects

```python
class PublishError(BaseIPFSToolException)
```

Exception on publish.

<a id="plugins.aea-cli-ipfs.aea_cli_ipfs.exceptions.NodeError"></a>

## NodeError Objects

```python
class NodeError(BaseIPFSToolException)
```

Exception for node connection check.

<a id="plugins.aea-cli-ipfs.aea_cli_ipfs.exceptions.DownloadError"></a>

## DownloadError Objects

```python
class DownloadError(BaseIPFSToolException)
```

Exception on download failed.

<a id="plugins.aea-cli-ipfs.aea_cli_ipfs.exceptions.HashNotProvided"></a>

## HashNotProvided Objects

```python
class HashNotProvided(BaseIPFSToolException)
```

Exception when hash is not provided.

