"""
PRIDE_search_proteomics

Search PRIDE proteomics database for experiments
"""

from typing import Any, Optional, Callable
from ._shared_client import get_shared_client


def PRIDE_search_proteomics(
    query: str,
    page_size: Optional[int] = 20,
    *,
    stream_callback: Optional[Callable[[str], None]] = None,
    use_cache: bool = False,
    validate: bool = True,
) -> dict[str, Any]:
    """
    Search PRIDE proteomics database for experiments

    Parameters
    ----------
    query : str
        Search query
    page_size : int
        Results per page
    stream_callback : Callable, optional
        Callback for streaming output
    use_cache : bool, default False
        Enable caching
    validate : bool, default True
        Validate parameters

    Returns
    -------
    dict[str, Any]
    """
    # Handle mutable defaults to avoid B006 linting error

    return get_shared_client().run_one_function(
        {
            "name": "PRIDE_search_proteomics",
            "arguments": {"query": query, "page_size": page_size},
        },
        stream_callback=stream_callback,
        use_cache=use_cache,
        validate=validate,
    )


__all__ = ["PRIDE_search_proteomics"]
