# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/fetch_tools.ipynb.

# %% ../nbs/fetch_tools.ipynb 3
from __future__ import annotations
import requests
from io import StringIO

import pandas as pd

# %% auto 0
__all__ = ['get_text_file_from_url']

# %% ../nbs/fetch_tools.ipynb 5
def get_text_file_from_url (url, #Data at this url must be readable with pandas.read_csv
             nrows: int=None, #Get only the first `nrows` from the file. If None, gets the entire file
             delimiter: str=',',
             headers: dict=None, #Headers to pass to the request
             skiprows: int=None, #Skip the first `skiprows` rows
             encoding: str='utf-8', #Encoding to use when reading the file
             **pd_read_csv_kwargs,
    ) -> pd.DataFrame:
    "Gets the first `nrows` from the file found at `url`. Data at `url` must be separated by `delimiter` and be readable by pandas.read_csv"


    if nrows is None:
        response = requests.get(url, headers=headers)
        response.raise_for_status()
        data = response.content.decode(encoding)
        return pd.read_csv(StringIO(data), delimiter=delimiter, skiprows=skiprows, **pd_read_csv_kwargs)

    response = requests.get(url, stream=True, headers=headers)
    response.raise_for_status()
    if skiprows is not None: nrows += skiprows
    lines = []
    for i, line in enumerate(response.iter_lines()):
        if skiprows is not None and i < skiprows: continue
        if i >= nrows: break
        lines.append(line.decode(encoding))
    data = '\n'.join(lines)
    return pd.read_csv(StringIO(data), delimiter=delimiter, **pd_read_csv_kwargs)

