"""Macro credit spread and excess bond premium"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/02_papers/gilchrist_zakrajsek_2012.ipynb.

# %% ../../nbs/02_papers/gilchrist_zakrajsek_2012.ipynb 3
from __future__ import annotations
import os

import pandas as pd

import pandasmore as pdm
from ..fetch_tools import get_text_file_from_url

# %% auto 0
__all__ = ['PROVIDER', 'URL', 'HOST_WEBSITE', 'FREQ', 'MIN_YEAR', 'MAX_YEAR', 'TIME_VAR_IN_RAW_DSET', 'TIME_VAR_IN_CLEAN_DSET',
           'get_raw_data', 'list_all_vars', 'process_raw_data']

# %% ../../nbs/02_papers/gilchrist_zakrajsek_2012.ipynb 4
PROVIDER = 'Gilchrist, Simon, and Egon Zakrajšek, 2012'
URL = 'https://www.federalreserve.gov/econres/notes/feds-notes/ebp_csv.csv'
HOST_WEBSITE = 'https://www.federalreserve.gov/econres/notes/feds-notes/updating-the-recession-risk-and-the-excess-bond-premium-20161006.html'
FREQ = 'M'
MIN_YEAR = 1973
MAX_YEAR = None
TIME_VAR_IN_RAW_DSET = 'date'
TIME_VAR_IN_CLEAN_DSET = f'{FREQ}date'

# %% ../../nbs/02_papers/gilchrist_zakrajsek_2012.ipynb 5
def get_raw_data(url: str=URL, 
            nrows: int=None, # How many rows to download. If None, all rows are downloaded
            delimiter: str=',',
            headers: dict=None,
            ) -> pd.DataFrame:
    """Download raw data from `url`"""
    if headers is None: headers = {'User-Agent': os.getenv('USER_AGENT', None)}
    if headers is None: print('No headers are provided. This may cause problems.')

    return get_text_file_from_url(url, nrows=nrows, delimiter=delimiter, headers=headers)

# %% ../../nbs/02_papers/gilchrist_zakrajsek_2012.ipynb 8
def list_all_vars():
    return pd.DataFrame(list(get_raw_data(nrows=1).columns), columns=['name'])

# %% ../../nbs/02_papers/gilchrist_zakrajsek_2012.ipynb 10
def process_raw_data(df: pd.DataFrame=None
                     ) -> pd.DataFrame:
    
    return pdm.setup_tseries(df, time_var=TIME_VAR_IN_RAW_DSET, freq=FREQ)
