"""WRDS Concordances"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/01_wrds/linking.ipynb.

# %% auto 0
__all__ = ['gvkey_permno_m', 'gvkey_permno_a', 'gvkey_permno_q', 'ibes_ticker_permno', 'bond_cusip_permno']

# %% ../../nbs/01_wrds/linking.ipynb 3
import pandas as pd

import pandasmore as pdm
from . import wrds_api

# %% ../../nbs/01_wrds/linking.ipynb 6
def gvkey_permno_m(nrows: int=None, #Number of rows to download. If None, full dataset will be downloaded
                   ) -> pd.DataFrame:
    """CRSP Monthly ids, with gvkeys"""

    limit_clause = f"LIMIT {nrows}" if nrows is not None else ""
    sql_string=f"""SELECT a.date, a.permno, c.gvkey
                  FROM crsp.msf a
                  INNER JOIN crsp.msenames b ON a.permno = b.permno
                                             AND a.date BETWEEN b.namedt AND b.nameendt 
                  INNER JOIN crsp.ccmxpf_lnkhist c ON a.permno = c.lpermno 
                                                   AND c.linktype IN ('LU','LC') AND c.linkprim IN ('P','C')
                                                   AND a.date BETWEEN c.linkdt AND COALESCE(c.linkenddt, CURRENT_DATE)
                    {limit_clause}                                   
                """
    
    df = wrds_api.download(sql_string)
    df = pdm.setup_panel(df, panel_ids='permno', time_var='date', freq='M',
                         drop_index_duplicates=True, duplicates_which_keep='last')
    df['gvkey'] = df['gvkey'].astype('string')
    return df.reset_index()[['permno','Mdate','gvkey']].copy()  

# %% ../../nbs/01_wrds/linking.ipynb 9
def gvkey_permno_a(nrows: int=None, #Number of rows to download. If None, full dataset will be downloaded
                   ) -> pd.DataFrame:
    """qvkey to permno correspondence at the annual frequency. As done by CCM."""

    limit_clause = f"LIMIT {nrows}" if nrows is not None else ""
    sql_string=f"""SELECT a.datadate, a.gvkey , b.lpermno as permno
                    FROM comp.funda a
                    INNER JOIN crsp.ccmxpf_lnkhist  b ON a.gvkey = b.gvkey
                    WHERE datadate BETWEEN b.linkdt AND COALESCE(b.linkenddt, CURRENT_DATE)
                            AND b.linktype IN ('LU','LC') AND b.linkprim IN ('P','C')
                            AND indfmt='INDL' AND datafmt='STD' AND popsrc='D' AND consol='C'
                    {limit_clause}            
                """
    
    df = wrds_api.download(sql_string)
    df = pdm.setup_panel(df, panel_ids='permno', time_var='datadate', freq='Y',
                         drop_index_duplicates=True, duplicates_which_keep='last')
    df['gvkey'] = df['gvkey'].astype('string')
    return df.reset_index()[['permno','Ydate','gvkey']].copy()  

# %% ../../nbs/01_wrds/linking.ipynb 12
def gvkey_permno_q(nrows : int=None, #Number of rows to download. If None, full dataset will be downloaded
                   ) -> pd.DataFrame:
    """qvkey to permno correspondence at the quarterly frequency. As done by CCM."""
    
    limit_clause = f"LIMIT {nrows}" if nrows is not None else ""
    sql_string=f"""SELECT a.datadate, a.gvkey , b.lpermno as permno
                    FROM comp.fundq a
                    INNER JOIN crsp.ccmxpf_lnkhist  b ON a.gvkey = b.gvkey
                    WHERE datadate BETWEEN b.linkdt AND COALESCE(b.linkenddt, CURRENT_DATE)
                            AND b.linktype IN ('LU','LC') AND b.linkprim IN ('P','C')
                            AND indfmt='INDL' AND datafmt='STD' AND popsrc='D' AND consol='C'            
                    {limit_clause}
                """
    
    df = wrds_api.download(sql_string)
    df = pdm.setup_panel(df, panel_ids='permno', time_var='datadate', freq='Q',
                         drop_index_duplicates=True, duplicates_which_keep='last')
    df['gvkey'] = df['gvkey'].astype('string')
    return df.reset_index()[['permno','Qdate','gvkey']].copy()    

# %% ../../nbs/01_wrds/linking.ipynb 16
def ibes_ticker_permno(nrows: int=None):
    limit_clause = ''
    if nrows is not None: limit_clause = f' LIMIT {nrows}'
    return wrds_api.download('SELECT * FROM wrdsapps_link_crsp_ibes.ibcrsphist' + limit_clause)

# %% ../../nbs/01_wrds/linking.ipynb 20
def bond_cusip_permno(nrows: int=None):
    limit_clause = ''
    if nrows is not None: limit_clause = f' LIMIT {nrows}'
    return wrds_api.download('SELECT * FROM wrdsapps.bondcrsp_link' + limit_clause)
