"""`wrds` package <https://github.com/wharton/wrds> plus a couple of utilities"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/01_wrds/00_wrds_api.ipynb.

# %% auto 0
__all__ = ['Connection', 'download', 'validate_dates']

# %% ../../nbs/01_wrds/00_wrds_api.ipynb 2
from typing import Sequence, List
import os 
import pandas as pd 
import wrds 
from datetime import datetime

# %% ../../nbs/01_wrds/00_wrds_api.ipynb 3
def Connection(): 
    return wrds.Connection(
        wrds_username=os.getenv("WRDS_USERNAME"), 
        wrds_password=os.getenv("WRDS_PASSWORD"),
        dtype_backend = "pyarrow",
        )

# %% ../../nbs/01_wrds/00_wrds_api.ipynb 4
def download(sql_string: str=None,
             params: Sequence=None # Params cited in the `sql_string`
             ) -> pd.DataFrame:
    """Downloads data from WRDS using the given PostgreSQL `sql_string`"""

    try:
        db = Connection()
        df = db.raw_sql(sql=sql_string, params=params)
    except Exception as err:
        raise err 
    finally:
        db.close()

    return df

# %% ../../nbs/01_wrds/00_wrds_api.ipynb 13
def validate_dates(date_strings: List[str]) -> bool:
    for date in date_strings:
        if date is not None:
            try:
                datetime.strptime(date, '%m/%d/%Y')
            except ValueError:
                raise ValueError(f"Date '{date}' is not in the correct format. Should be 'mm/dd/yyyy'")
