# generated by datamodel-codegen:
#   filename:  api/services/createPipelineService.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.services import pipelineService
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreatePipelineServiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies the this entity instance uniquely'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this pipeline service.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of pipeline service entity.'),
    ]
    serviceType: pipelineService.PipelineServiceType
    connection: Optional[pipelineService.PipelineConnection] = None
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Pipeline Service.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this pipeline service.'),
    ]
    scheduleInterval: Annotated[
        Optional[str],
        Field(None, description='Scheduler Interval for the pipeline in cron format.'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully qualified name of the domain the Pipeline Service belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
