# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/azureSQLConnection.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class Authentication(Enum):
    ActiveDirectoryIntegrated = 'ActiveDirectoryIntegrated'
    ActiveDirectoryPassword = 'ActiveDirectoryPassword'


class AuthenticationMode(BaseModel):
    authentication: Annotated[
        Optional[Authentication],
        Field(
            None,
            description='Authentication from Connection String for AzureSQL.',
            title='Authentication',
        ),
    ]
    encrypt: Annotated[
        Optional[bool],
        Field(
            None,
            description='Encrypt from Connection String for AzureSQL.',
            title='Encrypt',
        ),
    ]
    trustServerCertificate: Annotated[
        Optional[bool],
        Field(
            None,
            description='Trust Server Certificate from Connection String for AzureSQL.',
            title='Trust Server Certificate',
        ),
    ]
    connectionTimeout: Annotated[
        Optional[int],
        Field(
            30,
            description='Connection Timeout from Connection String for AzureSQL.',
            title='Connection Timeout',
        ),
    ]


class AzureSQLType(Enum):
    AzureSQL = 'AzureSQL'


class AzureSQLScheme(Enum):
    mssql_pyodbc = 'mssql+pyodbc'


class AzureSQLConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AzureSQLType],
        Field(AzureSQLType.AzureSQL, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[AzureSQLScheme],
        Field(
            AzureSQLScheme.mssql_pyodbc,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to AzureSQL. This user should have privileges to read the metadata.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to AzureSQL.', title='Password'),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the AzureSQL service.', title='Host and Port'
        ),
    ]
    database: Annotated[
        str,
        Field(
            description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
            title='Database',
        ),
    ]
    driver: Annotated[
        Optional[str],
        Field(
            'ODBC Driver 18 for SQL Server',
            description='SQLAlchemy driver for AzureSQL.',
            title='Driver',
        ),
    ]
    authenticationMode: Annotated[
        Optional[AuthenticationMode],
        Field(
            None,
            description="This parameter determines the mode of authentication for connecting to AzureSQL using ODBC. If 'Active Directory Password' is selected, you need to provide the password. If 'Active Directory Integrated' is selected, password is not required as it uses the logged-in user's credentials. This mode is useful for establishing secure and seamless connections with AzureSQL.",
            title='Authentication Mode',
        ),
    ]
    ingestAllDatabases: Annotated[
        Optional[bool],
        Field(
            False,
            description='Ingest data from all databases in Azuresql. You can use databaseFilterPattern on top of this.',
            title='Ingest All Databases',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsUsageExtraction: Annotated[
        Optional[connectionBasicType.SupportsUsageExtraction],
        Field(None, title='Supports Usage Extraction'),
    ]
    supportsLineageExtraction: Annotated[
        Optional[connectionBasicType.SupportsLineageExtraction],
        Field(None, title='Supports Lineage Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsDatabase: Annotated[
        Optional[connectionBasicType.SupportsDatabase],
        Field(None, title='Supports Database'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
