# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/prestoConnection.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class PrestoType(Enum):
    Presto = 'Presto'


class PrestoScheme(Enum):
    presto = 'presto'


class PrestoConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[PrestoType],
        Field(PrestoType.Presto, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[PrestoScheme],
        Field(
            PrestoScheme.presto,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to Presto. This user should have privileges to read all the metadata in Postgres.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to Presto.', title='Password'),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the Presto service.', title='Host and Port'
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
            title='Database Schema',
        ),
    ]
    catalog: Annotated[
        Optional[str], Field(None, description='Presto catalog', title='Catalog')
    ]
    protocol: Annotated[
        Optional[str],
        Field(
            None,
            description='Protocol ( Connection Argument ) to connect to Presto.',
            title='Protocol',
        ),
    ]
    verify: Annotated[
        Optional[str],
        Field(
            None,
            description='Verify ( Connection Argument for SSL ) to connect to Presto.',
            title='Verify',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    supportsDatabase: Annotated[
        Optional[connectionBasicType.SupportsDatabase],
        Field(None, title='Supports Database'),
    ]
    supportsQueryComment: Annotated[
        Optional[connectionBasicType.SupportsQueryComment],
        Field(None, title='Supports Query Comment'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
