# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceAutoClassificationPipeline.json
#   timestamp: 2025-08-12T13:13:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class AutoClassificationConfigType(Enum):
    AutoClassification = 'AutoClassification'


class DatabaseServiceAutoClassificationPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AutoClassificationConfigType],
        Field(
            AutoClassificationConfigType.AutoClassification, description='Pipeline type'
        ),
    ]
    classificationFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only compute metrics for table that matches the given tag, tiers, gloassary pattern.',
            title='Classification Filter Pattern',
        ),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch tables or databases that matches the pattern.',
            title='Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude tables or databases that matches the pattern.',
            title='Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch databases that matches the pattern.',
            title='Database Filter Pattern',
        ),
    ]
    includeViews: Annotated[
        Optional[bool],
        Field(
            True,
            description='Optional configuration to turn off fetching metadata for views.',
            title='Include Views',
        ),
    ]
    useFqnForFiltering: Annotated[
        Optional[bool],
        Field(
            False,
            description='Regex will be applied on fully qualified name (e.g service_name.db_name.schema_name.table_name) instead of raw name (e.g. table_name)',
            title='Use FQN For Filtering',
        ),
    ]
    storeSampleData: Annotated[
        Optional[bool],
        Field(
            True,
            description='Option to turn on/off storing sample data. If enabled, we will ingest sample data for each table.',
            title='Store Sample Data',
        ),
    ]
    enableAutoClassification: Annotated[
        Optional[bool],
        Field(
            False,
            description='Optional configuration to automatically tag columns that might contain sensitive information',
            title='Enable Auto Classification',
        ),
    ]
    confidence: Annotated[
        Optional[float],
        Field(
            80,
            description='Set the Confidence value for which you want the column to be tagged as PII. Confidence value ranges from 0 to 100. A higher number will yield less false positives but more false negatives. A lower number will yield more false positives but less false negatives.',
            title='Auto Classification Inference Confidence Level',
        ),
    ]
    sampleDataCount: Annotated[
        Optional[int],
        Field(
            50,
            description="Number of sample rows to ingest when 'Generate Sample Data' is enabled",
            title='Sample Data Rows Count',
        ),
    ]
