# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'DomainBootDeviceArgs',
    'DomainConsoleArgs',
    'DomainCpuArgs',
    'DomainDiskArgs',
    'DomainFilesystemArgs',
    'DomainGraphicsArgs',
    'DomainNetworkInterfaceArgs',
    'DomainNvramArgs',
    'DomainTpmArgs',
    'DomainVideoArgs',
    'DomainXmlArgs',
    'NetworkDhcpArgs',
    'NetworkDnsArgs',
    'NetworkDnsForwarderArgs',
    'NetworkDnsHostArgs',
    'NetworkDnsSrvArgs',
    'NetworkDnsmasqOptionsArgs',
    'NetworkDnsmasqOptionsOptionArgs',
    'NetworkRouteArgs',
    'NetworkXmlArgs',
    'PoolXmlArgs',
    'VolumeXmlArgs',
]

@pulumi.input_type
class DomainBootDeviceArgs:
    def __init__(__self__, *,
                 devs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if devs is not None:
            pulumi.set(__self__, "devs", devs)

    @property
    @pulumi.getter
    def devs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "devs")

    @devs.setter
    def devs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "devs", value)


@pulumi.input_type
class DomainConsoleArgs:
    def __init__(__self__, *,
                 target_port: pulumi.Input[str],
                 type: pulumi.Input[str],
                 source_host: Optional[pulumi.Input[str]] = None,
                 source_path: Optional[pulumi.Input[str]] = None,
                 source_service: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] target_port: Target port
        :param pulumi.Input[str] type: The type of hypervisor to use for the domain.  Defaults to `kvm`, other values can be found [here](https://libvirt.org/formatdomain.html#id1)
        :param pulumi.Input[str] source_host: IP address to listen on. Defaults to 127.0.0.1.
        :param pulumi.Input[str] source_path: Source path
               
               Additional attributes when type is "tcp":
        :param pulumi.Input[str] source_service: Port number or a service name. Defaults to a
               random port.
               
               Note that you can repeat the `console` block to create more than one console.
               This works the same way as with the `disk` blocks (see above).
               
               See [libvirt Domain XML Console element](https://libvirt.org/formatdomain.html#elementsConsole)
               for more information.
        :param pulumi.Input[str] target_type: for the first console and defaults to `serial`.
               Subsequent `console` blocks must have a different type - usually `virtio`.
               
               Additional attributes when type is "pty":
        """
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "type", type)
        if source_host is not None:
            pulumi.set(__self__, "source_host", source_host)
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)
        if source_service is not None:
            pulumi.set(__self__, "source_service", source_service)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> pulumi.Input[str]:
        """
        Target port
        """
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_port", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of hypervisor to use for the domain.  Defaults to `kvm`, other values can be found [here](https://libvirt.org/formatdomain.html#id1)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="sourceHost")
    def source_host(self) -> Optional[pulumi.Input[str]]:
        """
        IP address to listen on. Defaults to 127.0.0.1.
        """
        return pulumi.get(self, "source_host")

    @source_host.setter
    def source_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_host", value)

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[pulumi.Input[str]]:
        """
        Source path

        Additional attributes when type is "tcp":
        """
        return pulumi.get(self, "source_path")

    @source_path.setter
    def source_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_path", value)

    @property
    @pulumi.getter(name="sourceService")
    def source_service(self) -> Optional[pulumi.Input[str]]:
        """
        Port number or a service name. Defaults to a
        random port.

        Note that you can repeat the `console` block to create more than one console.
        This works the same way as with the `disk` blocks (see above).

        See [libvirt Domain XML Console element](https://libvirt.org/formatdomain.html#elementsConsole)
        for more information.
        """
        return pulumi.get(self, "source_service")

    @source_service.setter
    def source_service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_service", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        for the first console and defaults to `serial`.
        Subsequent `console` blocks must have a different type - usually `virtio`.

        Additional attributes when type is "pty":
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)


@pulumi.input_type
class DomainCpuArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None):
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class DomainDiskArgs:
    def __init__(__self__, *,
                 block_device: Optional[pulumi.Input[str]] = None,
                 file: Optional[pulumi.Input[str]] = None,
                 scsi: Optional[pulumi.Input[bool]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 volume_id: Optional[pulumi.Input[str]] = None,
                 wwn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] block_device: The path to the host device to use as the block device for this disk. 
               
               While `volume_id`, `url`, `file` and `block_device` are optional, it is intended that you use one of them.
        :param pulumi.Input[str] file: The filename to use as the block device for this disk (read-only)
        :param pulumi.Input[bool] scsi: Use a scsi controller for this disk.  The controller
               model is set to `virtio-scsi`
        :param pulumi.Input[str] url: The http url to use as the block device for this disk (read-only)
        :param pulumi.Input[str] volume_id: The volume id to use for this disk.
        :param pulumi.Input[str] wwn: Specify a WWN to use for the disk if the disk is using
               a scsi controller, if not specified then a random wwn is generated for the disk
               
               
               ```python
               import pulumi
               import pulumi_libvirt as libvirt
               
               leap = libvirt.Volume("leap", source="http://someurl/openSUSE_Leap-42.1.qcow2")
               mydisk = libvirt.Volume("mydisk", base_volume_id=leap.id)
               domain1 = libvirt.Domain("domain1", disks=[
                   libvirt.DomainDiskArgs(
                       volume_id=mydisk.id,
                       scsi=True,
                   ),
                   libvirt.DomainDiskArgs(
                       url="http://foo.com/install.iso",
                   ),
                   libvirt.DomainDiskArgs(
                       file="/absolute/path/to/disk.iso",
                   ),
                   libvirt.DomainDiskArgs(
                       block_device="/dev/mapper/36005076802810e55400000000000145f",
                   ),
               ])
               ```
               
               Also note that the `disk` block is actually a list of maps, so it is possible to
               declare several of them by using either the literal list and map syntax as in
               the following examples:
        """
        if block_device is not None:
            pulumi.set(__self__, "block_device", block_device)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if scsi is not None:
            pulumi.set(__self__, "scsi", scsi)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if wwn is not None:
            pulumi.set(__self__, "wwn", wwn)

    @property
    @pulumi.getter(name="blockDevice")
    def block_device(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the host device to use as the block device for this disk. 

        While `volume_id`, `url`, `file` and `block_device` are optional, it is intended that you use one of them.
        """
        return pulumi.get(self, "block_device")

    @block_device.setter
    def block_device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "block_device", value)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[str]]:
        """
        The filename to use as the block device for this disk (read-only)
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def scsi(self) -> Optional[pulumi.Input[bool]]:
        """
        Use a scsi controller for this disk.  The controller
        model is set to `virtio-scsi`
        """
        return pulumi.get(self, "scsi")

    @scsi.setter
    def scsi(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scsi", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The http url to use as the block device for this disk (read-only)
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[str]]:
        """
        The volume id to use for this disk.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter
    def wwn(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a WWN to use for the disk if the disk is using
        a scsi controller, if not specified then a random wwn is generated for the disk


        ```python
        import pulumi
        import pulumi_libvirt as libvirt

        leap = libvirt.Volume("leap", source="http://someurl/openSUSE_Leap-42.1.qcow2")
        mydisk = libvirt.Volume("mydisk", base_volume_id=leap.id)
        domain1 = libvirt.Domain("domain1", disks=[
            libvirt.DomainDiskArgs(
                volume_id=mydisk.id,
                scsi=True,
            ),
            libvirt.DomainDiskArgs(
                url="http://foo.com/install.iso",
            ),
            libvirt.DomainDiskArgs(
                file="/absolute/path/to/disk.iso",
            ),
            libvirt.DomainDiskArgs(
                block_device="/dev/mapper/36005076802810e55400000000000145f",
            ),
        ])
        ```

        Also note that the `disk` block is actually a list of maps, so it is possible to
        declare several of them by using either the literal list and map syntax as in
        the following examples:
        """
        return pulumi.get(self, "wwn")

    @wwn.setter
    def wwn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wwn", value)


@pulumi.input_type
class DomainFilesystemArgs:
    def __init__(__self__, *,
                 source: pulumi.Input[str],
                 target: pulumi.Input[str],
                 accessmode: Optional[pulumi.Input[str]] = None,
                 readonly: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] source: the directory of the host to be shared with the guest.
        :param pulumi.Input[str] target: an arbitrary string tag that is exported to the guest as a hint for
               where to mount the source.
        :param pulumi.Input[str] accessmode: specifies the security mode for accessing the source. By default
               the `mapped` mode is chosen.
        :param pulumi.Input[bool] readonly: enables exporting filesystem as a readonly mount for guest, by
               default read-only access is given.
               
               Example:
               
               ```python
               import pulumi
               ```
               
               The exported filesystems can be mounted inside of the guest in this way:
               
               
               This can be automated inside of `/etc/fstab`:
        """
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if accessmode is not None:
            pulumi.set(__self__, "accessmode", accessmode)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        the directory of the host to be shared with the guest.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        """
        an arbitrary string tag that is exported to the guest as a hint for
        where to mount the source.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def accessmode(self) -> Optional[pulumi.Input[str]]:
        """
        specifies the security mode for accessing the source. By default
        the `mapped` mode is chosen.
        """
        return pulumi.get(self, "accessmode")

    @accessmode.setter
    def accessmode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessmode", value)

    @property
    @pulumi.getter
    def readonly(self) -> Optional[pulumi.Input[bool]]:
        """
        enables exporting filesystem as a readonly mount for guest, by
        default read-only access is given.

        Example:

        ```python
        import pulumi
        ```

        The exported filesystems can be mounted inside of the guest in this way:


        This can be automated inside of `/etc/fstab`:
        """
        return pulumi.get(self, "readonly")

    @readonly.setter
    def readonly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "readonly", value)


@pulumi.input_type
class DomainGraphicsArgs:
    def __init__(__self__, *,
                 autoport: Optional[pulumi.Input[bool]] = None,
                 listen_address: Optional[pulumi.Input[str]] = None,
                 listen_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 websocket: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] autoport: defaults to "yes"
        :param pulumi.Input[str] listen_address: IP Address where the VNC listener should be started if
               `listen_type` is set to `address`. Defaults to 127.0.0.1
        :param pulumi.Input[str] listen_type: "listen type", defaults to "none"
        :param pulumi.Input[str] type: The type of hypervisor to use for the domain.  Defaults to `kvm`, other values can be found [here](https://libvirt.org/formatdomain.html#id1)
        :param pulumi.Input[int] websocket: Port to listen on for VNC WebSocket functionality (-1 meaning auto-allocation)
               
               On occasion we have found it necessary to set a `type` of `vnc` and a
               `listen_type` of `address` with certain builds of QEMU.
               
               With `listen_address` it is possible to specify a listener address for the virtual
               machines VNC server. Usually this is an IP of the host system.
               
               The `graphics` block will look as follows:
               
               
               The video card type can be changed from libvirt default `cirrus` to
               `vga` or others as described in [Video Card Elements](https://libvirt.org/formatdomain.html#elementsVideo)
               
               
               > **Note well:** the `graphics` block is ignored for the architectures
               `s390x` and `ppc64`.
        """
        if autoport is not None:
            pulumi.set(__self__, "autoport", autoport)
        if listen_address is not None:
            pulumi.set(__self__, "listen_address", listen_address)
        if listen_type is not None:
            pulumi.set(__self__, "listen_type", listen_type)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if websocket is not None:
            pulumi.set(__self__, "websocket", websocket)

    @property
    @pulumi.getter
    def autoport(self) -> Optional[pulumi.Input[bool]]:
        """
        defaults to "yes"
        """
        return pulumi.get(self, "autoport")

    @autoport.setter
    def autoport(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoport", value)

    @property
    @pulumi.getter(name="listenAddress")
    def listen_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address where the VNC listener should be started if
        `listen_type` is set to `address`. Defaults to 127.0.0.1
        """
        return pulumi.get(self, "listen_address")

    @listen_address.setter
    def listen_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listen_address", value)

    @property
    @pulumi.getter(name="listenType")
    def listen_type(self) -> Optional[pulumi.Input[str]]:
        """
        "listen type", defaults to "none"
        """
        return pulumi.get(self, "listen_type")

    @listen_type.setter
    def listen_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listen_type", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of hypervisor to use for the domain.  Defaults to `kvm`, other values can be found [here](https://libvirt.org/formatdomain.html#id1)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def websocket(self) -> Optional[pulumi.Input[int]]:
        """
        Port to listen on for VNC WebSocket functionality (-1 meaning auto-allocation)

        On occasion we have found it necessary to set a `type` of `vnc` and a
        `listen_type` of `address` with certain builds of QEMU.

        With `listen_address` it is possible to specify a listener address for the virtual
        machines VNC server. Usually this is an IP of the host system.

        The `graphics` block will look as follows:


        The video card type can be changed from libvirt default `cirrus` to
        `vga` or others as described in [Video Card Elements](https://libvirt.org/formatdomain.html#elementsVideo)


        > **Note well:** the `graphics` block is ignored for the architectures
        `s390x` and `ppc64`.
        """
        return pulumi.get(self, "websocket")

    @websocket.setter
    def websocket(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "websocket", value)


@pulumi.input_type
class DomainNetworkInterfaceArgs:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bridge: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 macvtap: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 network_name: Optional[pulumi.Input[str]] = None,
                 passthrough: Optional[pulumi.Input[str]] = None,
                 vepa: Optional[pulumi.Input[str]] = None,
                 wait_for_lease: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: An IP address for this domain in this network.
        :param pulumi.Input[str] bridge: Provides a bridge from the VM directly to the LAN. This assumes
               there is a bridge device on the host which has one or more of the hosts
               physical NICs enslaved. The guest VM will have an associated _tun_ device
               created and enslaved to the bridge. The IP range / network configuration is
               whatever is used on the LAN. This provides the guest VM full incoming &
               outgoing net access just like a physical machine.
        :param pulumi.Input[str] hostname: A hostname that will be assigned to this domain
               resource in this network.
        :param pulumi.Input[str] mac: The specific MAC address to use for this interface.
        :param pulumi.Input[str] macvtap: Packets whose destination is on the same host as where they
               originate from are directly delivered to the target macvtap device. Both
               origin and destination devices need to be in bridge mode for direct delivery.
               If either one of them is in vepa mode, a VEPA capable bridge is required.
        :param pulumi.Input[str] passthrough: This feature attaches a virtual function of a SRIOV capable
               NIC directly to a VM without losing the migration capability. All packets are
               sent to the VF/IF of the configured network device. Depending on the
               capabilities of the device additional prerequisites or limitations may apply;
               for example, on Linux this requires kernel 2.6.38 or newer.
               
               Example of a `macvtap` interface:
               
               
               **Warning:** the [Qemu guest agent](http://wiki.libvirt.org/page/Qemu_guest_agent)
               must be installed and running inside of the domain in order to discover the IP
               addresses of all the network interfaces attached to a LAN.
        :param pulumi.Input[str] vepa: All VMs' packets are sent to the external bridge. Packets whose
               destination is a VM on the same host as where the packet originates from are
               sent back to the host by the VEPA capable bridge (today's bridges are
               typically not VEPA capable).
        :param pulumi.Input[bool] wait_for_lease: When creating the domain resource, wait until the
               network interface gets a DHCP lease from libvirt, so that the computed IP
               addresses will be available when the domain is up and the plan applied.
               
               When connecting to a LAN, users can specify a target device with:
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if bridge is not None:
            pulumi.set(__self__, "bridge", bridge)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if macvtap is not None:
            pulumi.set(__self__, "macvtap", macvtap)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if network_name is not None:
            pulumi.set(__self__, "network_name", network_name)
        if passthrough is not None:
            pulumi.set(__self__, "passthrough", passthrough)
        if vepa is not None:
            pulumi.set(__self__, "vepa", vepa)
        if wait_for_lease is not None:
            pulumi.set(__self__, "wait_for_lease", wait_for_lease)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An IP address for this domain in this network.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def bridge(self) -> Optional[pulumi.Input[str]]:
        """
        Provides a bridge from the VM directly to the LAN. This assumes
        there is a bridge device on the host which has one or more of the hosts
        physical NICs enslaved. The guest VM will have an associated _tun_ device
        created and enslaved to the bridge. The IP range / network configuration is
        whatever is used on the LAN. This provides the guest VM full incoming &
        outgoing net access just like a physical machine.
        """
        return pulumi.get(self, "bridge")

    @bridge.setter
    def bridge(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bridge", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        A hostname that will be assigned to this domain
        resource in this network.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[str]]:
        """
        The specific MAC address to use for this interface.
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac", value)

    @property
    @pulumi.getter
    def macvtap(self) -> Optional[pulumi.Input[str]]:
        """
        Packets whose destination is on the same host as where they
        originate from are directly delivered to the target macvtap device. Both
        origin and destination devices need to be in bridge mode for direct delivery.
        If either one of them is in vepa mode, a VEPA capable bridge is required.
        """
        return pulumi.get(self, "macvtap")

    @macvtap.setter
    def macvtap(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "macvtap", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter
    def passthrough(self) -> Optional[pulumi.Input[str]]:
        """
        This feature attaches a virtual function of a SRIOV capable
        NIC directly to a VM without losing the migration capability. All packets are
        sent to the VF/IF of the configured network device. Depending on the
        capabilities of the device additional prerequisites or limitations may apply;
        for example, on Linux this requires kernel 2.6.38 or newer.

        Example of a `macvtap` interface:


        **Warning:** the [Qemu guest agent](http://wiki.libvirt.org/page/Qemu_guest_agent)
        must be installed and running inside of the domain in order to discover the IP
        addresses of all the network interfaces attached to a LAN.
        """
        return pulumi.get(self, "passthrough")

    @passthrough.setter
    def passthrough(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "passthrough", value)

    @property
    @pulumi.getter
    def vepa(self) -> Optional[pulumi.Input[str]]:
        """
        All VMs' packets are sent to the external bridge. Packets whose
        destination is a VM on the same host as where the packet originates from are
        sent back to the host by the VEPA capable bridge (today's bridges are
        typically not VEPA capable).
        """
        return pulumi.get(self, "vepa")

    @vepa.setter
    def vepa(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vepa", value)

    @property
    @pulumi.getter(name="waitForLease")
    def wait_for_lease(self) -> Optional[pulumi.Input[bool]]:
        """
        When creating the domain resource, wait until the
        network interface gets a DHCP lease from libvirt, so that the computed IP
        addresses will be available when the domain is up and the plan applied.

        When connecting to a LAN, users can specify a target device with:
        """
        return pulumi.get(self, "wait_for_lease")

    @wait_for_lease.setter
    def wait_for_lease(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_lease", value)


@pulumi.input_type
class DomainNvramArgs:
    def __init__(__self__, *,
                 file: pulumi.Input[str],
                 template: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] file: The filename to use as the block device for this disk (read-only)
        :param pulumi.Input[str] template: path to the file used to override variables from the master NVRAM
               store.
               
               So you should typically use the firmware as this,
               
               
               and `/etc/libvirt/qemu.conf` should contain:
               
               ```python
               import pulumi
               ```
               
               In case you need (or want) to specify the path for the NVRAM store, the domain definition should
               look like this:
               
               
               Finally, if you want the initial values for the NVRAM to be overridden by custom initial values
               coming from a template, the domain definition should look like this:
        """
        pulumi.set(__self__, "file", file)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def file(self) -> pulumi.Input[str]:
        """
        The filename to use as the block device for this disk (read-only)
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: pulumi.Input[str]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        path to the file used to override variables from the master NVRAM
        store.

        So you should typically use the firmware as this,


        and `/etc/libvirt/qemu.conf` should contain:

        ```python
        import pulumi
        ```

        In case you need (or want) to specify the path for the NVRAM store, the domain definition should
        look like this:


        Finally, if you want the initial values for the NVRAM to be overridden by custom initial values
        coming from a template, the domain definition should look like this:
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class DomainTpmArgs:
    def __init__(__self__, *,
                 backend_device_path: Optional[pulumi.Input[str]] = None,
                 backend_encryption_secret: Optional[pulumi.Input[str]] = None,
                 backend_persistent_state: Optional[pulumi.Input[bool]] = None,
                 backend_type: Optional[pulumi.Input[str]] = None,
                 backend_version: Optional[pulumi.Input[str]] = None,
                 model: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] backend_device_path: Path to TPM device on the host, ex: `/dev/tpm0`
               
               Additional attributes when `backend_type` is "emulator":
        :param pulumi.Input[str] backend_encryption_secret: [Secret object](https://libvirt.org/formatsecret.html) for encrypting the TPM state
        :param pulumi.Input[bool] backend_persistent_state: Keep the TPM state when a transient domain is powered off or undefined
        :param pulumi.Input[str] backend_type: TPM backend, either `passthrough` or `emulator` (default: `emulator`)
               
               Additional attributes when `backend_type` is "passthrough":
        :param pulumi.Input[str] backend_version: TPM version
        :param pulumi.Input[str] model: TPM model provided to the guest
        """
        if backend_device_path is not None:
            pulumi.set(__self__, "backend_device_path", backend_device_path)
        if backend_encryption_secret is not None:
            pulumi.set(__self__, "backend_encryption_secret", backend_encryption_secret)
        if backend_persistent_state is not None:
            pulumi.set(__self__, "backend_persistent_state", backend_persistent_state)
        if backend_type is not None:
            pulumi.set(__self__, "backend_type", backend_type)
        if backend_version is not None:
            pulumi.set(__self__, "backend_version", backend_version)
        if model is not None:
            pulumi.set(__self__, "model", model)

    @property
    @pulumi.getter(name="backendDevicePath")
    def backend_device_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to TPM device on the host, ex: `/dev/tpm0`

        Additional attributes when `backend_type` is "emulator":
        """
        return pulumi.get(self, "backend_device_path")

    @backend_device_path.setter
    def backend_device_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_device_path", value)

    @property
    @pulumi.getter(name="backendEncryptionSecret")
    def backend_encryption_secret(self) -> Optional[pulumi.Input[str]]:
        """
        [Secret object](https://libvirt.org/formatsecret.html) for encrypting the TPM state
        """
        return pulumi.get(self, "backend_encryption_secret")

    @backend_encryption_secret.setter
    def backend_encryption_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_encryption_secret", value)

    @property
    @pulumi.getter(name="backendPersistentState")
    def backend_persistent_state(self) -> Optional[pulumi.Input[bool]]:
        """
        Keep the TPM state when a transient domain is powered off or undefined
        """
        return pulumi.get(self, "backend_persistent_state")

    @backend_persistent_state.setter
    def backend_persistent_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backend_persistent_state", value)

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> Optional[pulumi.Input[str]]:
        """
        TPM backend, either `passthrough` or `emulator` (default: `emulator`)

        Additional attributes when `backend_type` is "passthrough":
        """
        return pulumi.get(self, "backend_type")

    @backend_type.setter
    def backend_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_type", value)

    @property
    @pulumi.getter(name="backendVersion")
    def backend_version(self) -> Optional[pulumi.Input[str]]:
        """
        TPM version
        """
        return pulumi.get(self, "backend_version")

    @backend_version.setter
    def backend_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend_version", value)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[str]]:
        """
        TPM model provided to the guest
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model", value)


@pulumi.input_type
class DomainVideoArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of hypervisor to use for the domain.  Defaults to `kvm`, other values can be found [here](https://libvirt.org/formatdomain.html#id1)
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of hypervisor to use for the domain.  Defaults to `kvm`, other values can be found [here](https://libvirt.org/formatdomain.html#id1)
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class DomainXmlArgs:
    def __init__(__self__, *,
                 xslt: Optional[pulumi.Input[str]] = None):
        if xslt is not None:
            pulumi.set(__self__, "xslt", xslt)

    @property
    @pulumi.getter
    def xslt(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "xslt")

    @xslt.setter
    def xslt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xslt", value)


@pulumi.input_type
class NetworkDhcpArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] enabled: when false, disable the DHCP server
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        when false, disable the DHCP server
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class NetworkDnsArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 forwarders: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsForwarderArgs']]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsHostArgs']]]] = None,
                 local_only: Optional[pulumi.Input[bool]] = None,
                 srvs: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsSrvArgs']]]] = None):
        """
        :param pulumi.Input[bool] enabled: when false, disable the DHCP server
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDnsForwarderArgs']]] forwarders: Either `address`, `domain`, or both must be set
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDnsHostArgs']]] hosts: a DNS host entry block. You can have one or more of these
               blocks in your DNS definition. You must specify both `ip` and `hostname`.
               
               An advanced example of round-robin DNS (using DNS host templates) follows:
               
               
               An advanced example of setting up multiple SRV records using DNS SRV templates is:
        :param pulumi.Input[bool] local_only: true/false: true means 'do not forward unresolved requests for this domain to the part DNS server
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDnsSrvArgs']]] srvs: a DNS SRV entry block. You can have one or more of these blocks
               in your DNS definition. You must specify `service` and `protocol`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if forwarders is not None:
            pulumi.set(__self__, "forwarders", forwarders)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if local_only is not None:
            pulumi.set(__self__, "local_only", local_only)
        if srvs is not None:
            pulumi.set(__self__, "srvs", srvs)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        when false, disable the DHCP server
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def forwarders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsForwarderArgs']]]]:
        """
        Either `address`, `domain`, or both must be set
        """
        return pulumi.get(self, "forwarders")

    @forwarders.setter
    def forwarders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsForwarderArgs']]]]):
        pulumi.set(self, "forwarders", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsHostArgs']]]]:
        """
        a DNS host entry block. You can have one or more of these
        blocks in your DNS definition. You must specify both `ip` and `hostname`.

        An advanced example of round-robin DNS (using DNS host templates) follows:


        An advanced example of setting up multiple SRV records using DNS SRV templates is:
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="localOnly")
    def local_only(self) -> Optional[pulumi.Input[bool]]:
        """
        true/false: true means 'do not forward unresolved requests for this domain to the part DNS server
        """
        return pulumi.get(self, "local_only")

    @local_only.setter
    def local_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_only", value)

    @property
    @pulumi.getter
    def srvs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsSrvArgs']]]]:
        """
        a DNS SRV entry block. You can have one or more of these blocks
        in your DNS definition. You must specify `service` and `protocol`.
        """
        return pulumi.get(self, "srvs")

    @srvs.setter
    def srvs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsSrvArgs']]]]):
        pulumi.set(self, "srvs", value)


@pulumi.input_type
class NetworkDnsForwarderArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain: The domain used by the DNS server.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain used by the DNS server.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)


@pulumi.input_type
class NetworkDnsHostArgs:
    def __init__(__self__, *,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None):
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class NetworkDnsSrvArgs:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain: The domain used by the DNS server.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain used by the DNS server.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class NetworkDnsmasqOptionsArgs:
    def __init__(__self__, *,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsmasqOptionsOptionArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['NetworkDnsmasqOptionsOptionArgs']]] options: a Dnsmasq option entry block. You can have one or more of these
               blocks in your definition. You must specify `option_name` while `option_value` is
               optional to support value-less options.
               
               An example of setting Dnsmasq options (using Dnsmasq option templates) follows:
        """
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsmasqOptionsOptionArgs']]]]:
        """
        a Dnsmasq option entry block. You can have one or more of these
        blocks in your definition. You must specify `option_name` while `option_value` is
        optional to support value-less options.

        An example of setting Dnsmasq options (using Dnsmasq option templates) follows:
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkDnsmasqOptionsOptionArgs']]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class NetworkDnsmasqOptionsOptionArgs:
    def __init__(__self__, *,
                 option_name: Optional[pulumi.Input[str]] = None,
                 option_value: Optional[pulumi.Input[str]] = None):
        if option_name is not None:
            pulumi.set(__self__, "option_name", option_name)
        if option_value is not None:
            pulumi.set(__self__, "option_value", option_value)

    @property
    @pulumi.getter(name="optionName")
    def option_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "option_name")

    @option_name.setter
    def option_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option_name", value)

    @property
    @pulumi.getter(name="optionValue")
    def option_value(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "option_value")

    @option_value.setter
    def option_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option_value", value)


@pulumi.input_type
class NetworkRouteArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 gateway: pulumi.Input[str]):
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[str]:
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway", value)


@pulumi.input_type
class NetworkXmlArgs:
    def __init__(__self__, *,
                 xslt: Optional[pulumi.Input[str]] = None):
        if xslt is not None:
            pulumi.set(__self__, "xslt", xslt)

    @property
    @pulumi.getter
    def xslt(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "xslt")

    @xslt.setter
    def xslt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xslt", value)


@pulumi.input_type
class PoolXmlArgs:
    def __init__(__self__, *,
                 xslt: Optional[pulumi.Input[str]] = None):
        if xslt is not None:
            pulumi.set(__self__, "xslt", xslt)

    @property
    @pulumi.getter
    def xslt(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "xslt")

    @xslt.setter
    def xslt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xslt", value)


@pulumi.input_type
class VolumeXmlArgs:
    def __init__(__self__, *,
                 xslt: Optional[pulumi.Input[str]] = None):
        if xslt is not None:
            pulumi.set(__self__, "xslt", xslt)

    @property
    @pulumi.getter
    def xslt(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "xslt")

    @xslt.setter
    def xslt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xslt", value)


