# Generated by Django 5.0.8 on 2024-10-20 19:24

from django.db import migrations, models


def set_enabled_trial_at(apps, schema_editor):
    Subscription = apps.get_model("database", "Subscription")
    for subscription in Subscription.objects.all():
        subscription.enabled_trial_at = subscription.created_at
        subscription.save()


class Migration(migrations.Migration):
    dependencies = [
        ("database", "0070_alter_agent_input_tools_alter_agent_output_modes"),
    ]

    operations = [
        migrations.AddField(
            model_name="subscription",
            name="enabled_trial_at",
            field=models.DateTimeField(blank=True, default=None, null=True),
        ),
        migrations.AlterField(
            model_name="subscription",
            name="type",
            field=models.CharField(
                choices=[("trial", "Trial"), ("standard", "Standard")], default="standard", max_length=20
            ),
        ),
        migrations.RunPython(set_enabled_trial_at),
    ]
