/*
 * Decompiled with CFR 0.152.
 */
package jnegmas;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import jnegmas.PyCallable;
import jnegmas.PyCaller;
import py4j.ClientServer;
import py4j.GatewayServer;

public class JNegmasApp {
    private static final int DEFAULT_JAVA_PORT = 25333;
    private static final int DEFAULT_PYTHON_PORT = 25334;

    public Object create(String class_name) {
        System.out.format("Creating %s\n", class_name);
        try {
            Class<?> clazz = Class.forName(class_name);
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public PyCaller create(String class_name, PyCallable python_object) {
        System.out.format("Creating %s with python object\n", class_name);
        PyCaller java_object = (PyCaller)this.create(class_name);
        java_object.setPythonShadow(python_object);
        return java_object;
    }

    public static void usage() {
        System.out.print("Usage: jnemas [--die-on-exit/--doe/-d] [--port/-p int][--client-server|--gateway]\nDefault is: --client-server\nThe Python side should use the same client-server/gateway setting and connect to the same port");
    }

    public static void main(String[] args) {
        Object server;
        int port = 25333;
        boolean dieOnBrokenPipe = false;
        boolean use_client_server = true;
        System.out.format("Received options: ", new Object[0]);
        for (int i = 0; i < args.length; ++i) {
            String opt = args[i];
            System.out.format("%s ", opt);
            if (opt.equals("--die-on-exit") || opt.equals("--doe") || opt.equals("-d")) {
                dieOnBrokenPipe = true;
                continue;
            }
            if (opt.equals("--client-server") || opt.equals("--single-thread")) {
                use_client_server = true;
                continue;
            }
            if (opt.equals("--gateway") || opt.equals("--multiple-threads")) {
                use_client_server = false;
                continue;
            }
            if (opt.equals("-p") || opt.equals("--port")) {
                if (i < args.length - 1) {
                    try {
                        port = Integer.parseInt(args[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException e) {
                        System.out.format("%s is not a number! (port numbers must be numbers)\n\n", args[i + 1]);
                        JNegmasApp.usage();
                        System.exit(-1);
                    }
                    continue;
                }
                System.out.format("Cannot pass %s as last argument\n\n", opt);
                JNegmasApp.usage();
                System.exit(-1);
                continue;
            }
            System.out.format("Unknown argument: %s\n\n", opt);
            JNegmasApp.usage();
            System.exit(-1);
        }
        System.out.format("\n", new Object[0]);
        JNegmasApp app = new JNegmasApp();
        if (use_client_server) {
            server = new ClientServer(app);
            ((ClientServer)server).startServer();
            System.out.format("Gateway to NegMAS started at port %d (single-thread)\n", port);
        } else {
            server = new GatewayServer(app, port);
            int listening_port = ((GatewayServer)server).getListeningPort();
            System.out.format("Gateway to NegMAS started at port %d listening to port %d (multiple-threads)\n", port, listening_port);
        }
        if (dieOnBrokenPipe) {
            try {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
                stdin.readLine();
                System.exit(0);
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
    }
}

