"""
Generated by qenerate plugin=pydantic_v2. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    ConfigDict,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.oc_connection_cluster import OcConnectionCluster


DEFINITION = """
fragment CommonJumphostFields on ClusterJumpHost_v1 {
  hostname
  knownHosts
  user
  port
  remotePort
  identity {
    ...VaultSecret
  }
}

fragment OcConnectionCluster on Cluster_v1 {
  name
  serverUrl
  internal
  insecureSkipTLSVerify
  jumpHost {
    ...CommonJumphostFields
  }
  automationToken {
    ...VaultSecret
  }
  clusterAdminAutomationToken {
    ...VaultSecret
  }
  disable {
    integrations
  }
}

fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query AutomatedActionsInstances {
  automated_actions_instances_v1 {
    name
    deployment {
      name
      clusterAdmin
      delete
      cluster {
        ...OcConnectionCluster
      }
    }
    actions {
      type
      permissions {
        roles {
          name
          users {
            org_username
          }
          bots {
            org_username
          }
          expirationDate
        }
      }
      maxOps
      ... on AutomatedActionActionList_v1 {
        action_list_arguments: arguments {
          action_user
          max_age_minutes
        }
      }
      ... on AutomatedActionExternalResourceFlushElastiCache_v1 {
        external_resource_flush_elasticache_arguments: arguments {
          namespace {
            externalResources {
              provisioner {
                ... on AWSAccount_v1 {
                  name
                }
              }
            }
          }
          identifier
        }
      }
      ... on AutomatedActionExternalResourceRdsReboot_v1 {
        external_resource_rds_reboot_arguments: arguments {
          namespace {
            externalResources {
              provisioner {
                ... on AWSAccount_v1 {
                  name
                }
              }
            }
          }
          identifier
        }
      }
      ... on AutomatedActionExternalResourceRdsSnapshot_v1 {
        external_resource_rds_snapshot_arguments: arguments {
          namespace {
            externalResources {
              provisioner {
                ... on AWSAccount_v1 {
                  name
                }
              }
            }
          }
          identifier
        }
      }
      ... on AutomatedActionOpenshiftTriggerCronjob_v1 {
        openshift_trigger_cronjob_arguments: arguments {
          namespace {
            name
            delete
            cluster {
              name
              disable {
                integrations
              }
            }
          }
          cronjob
        }
      }
      ... on AutomatedActionOpenshiftWorkloadDelete_v1 {
        openshift_workload_delete_arguments: arguments {
          namespace {
            name
            delete
            cluster {
              name
              disable {
                integrations
              }
            }
          }
          api_version
          kind
          name
        }
      }
      ... on AutomatedActionOpenshiftWorkloadRestart_v1 {
        openshift_workload_restart_arguments: arguments {
          namespace {
            name
            delete
            cluster {
              name
              disable {
                integrations
              }
            }
          }
          kind
          name
        }
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid'
    )


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    cluster_admin: Optional[bool] = Field(..., alias="clusterAdmin")
    delete: Optional[bool] = Field(..., alias="delete")
    cluster: OcConnectionCluster = Field(..., alias="cluster")


class UserV1(ConfiguredBaseModel):
    org_username: str = Field(..., alias="org_username")


class BotV1(ConfiguredBaseModel):
    org_username: Optional[str] = Field(..., alias="org_username")


class RoleV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    users: list[UserV1] = Field(..., alias="users")
    bots: list[BotV1] = Field(..., alias="bots")
    expiration_date: Optional[str] = Field(..., alias="expirationDate")


class PermissionAutomatedActionsV1(ConfiguredBaseModel):
    roles: Optional[list[RoleV1]] = Field(..., alias="roles")


class AutomatedActionV1(ConfiguredBaseModel):
    q_type: str = Field(..., alias="type")
    permissions: Optional[list[PermissionAutomatedActionsV1]] = Field(..., alias="permissions")
    max_ops: int = Field(..., alias="maxOps")


class AutomatedActionActionListArgumentV1(ConfiguredBaseModel):
    action_user: Optional[str] = Field(..., alias="action_user")
    max_age_minutes: Optional[int] = Field(..., alias="max_age_minutes")


class AutomatedActionActionListV1(AutomatedActionV1):
    action_list_arguments: Optional[list[AutomatedActionActionListArgumentV1]] = Field(..., alias="action_list_arguments")


class ExternalResourcesProvisionerV1(ConfiguredBaseModel):
    ...


class AWSAccountV1(ExternalResourcesProvisionerV1):
    name: str = Field(..., alias="name")


class NamespaceExternalResourceV1(ConfiguredBaseModel):
    provisioner: Union[AWSAccountV1, ExternalResourcesProvisionerV1] = Field(..., alias="provisioner")


class AutomatedActionExternalResourceArgumentV1_NamespaceV1(ConfiguredBaseModel):
    external_resources: Optional[list[NamespaceExternalResourceV1]] = Field(..., alias="externalResources")


class AutomatedActionExternalResourceArgumentV1(ConfiguredBaseModel):
    namespace: AutomatedActionExternalResourceArgumentV1_NamespaceV1 = Field(..., alias="namespace")
    identifier: str = Field(..., alias="identifier")


class AutomatedActionExternalResourceFlushElastiCacheV1(AutomatedActionV1):
    external_resource_flush_elasticache_arguments: list[AutomatedActionExternalResourceArgumentV1] = Field(..., alias="external_resource_flush_elasticache_arguments")


class AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1(ConfiguredBaseModel):
    ...


class AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1_AWSAccountV1(AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1):
    name: str = Field(..., alias="name")


class AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1(ConfiguredBaseModel):
    provisioner: Union[AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1_AWSAccountV1, AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1] = Field(..., alias="provisioner")


class AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1(ConfiguredBaseModel):
    external_resources: Optional[list[AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1]] = Field(..., alias="externalResources")


class AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1(ConfiguredBaseModel):
    namespace: AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1 = Field(..., alias="namespace")
    identifier: str = Field(..., alias="identifier")


class AutomatedActionExternalResourceRdsRebootV1(AutomatedActionV1):
    external_resource_rds_reboot_arguments: list[AutomatedActionExternalResourceRdsRebootV1_AutomatedActionExternalResourceArgumentV1] = Field(..., alias="external_resource_rds_reboot_arguments")


class AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1(ConfiguredBaseModel):
    ...


class AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1_AWSAccountV1(AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1):
    name: str = Field(..., alias="name")


class AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1(ConfiguredBaseModel):
    provisioner: Union[AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1_AWSAccountV1, AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1_ExternalResourcesProvisionerV1] = Field(..., alias="provisioner")


class AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1(ConfiguredBaseModel):
    external_resources: Optional[list[AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1_NamespaceExternalResourceV1]] = Field(..., alias="externalResources")


class AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1(ConfiguredBaseModel):
    namespace: AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1_NamespaceV1 = Field(..., alias="namespace")
    identifier: str = Field(..., alias="identifier")


class AutomatedActionExternalResourceRdsSnapshotV1(AutomatedActionV1):
    external_resource_rds_snapshot_arguments: list[AutomatedActionExternalResourceRdsSnapshotV1_AutomatedActionExternalResourceArgumentV1] = Field(..., alias="external_resource_rds_snapshot_arguments")


class DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class AutomatedActionOpenshiftTriggerCronjobArgumentV1_NamespaceV1_ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    disable: Optional[DisableClusterAutomationsV1] = Field(..., alias="disable")


class AutomatedActionOpenshiftTriggerCronjobArgumentV1_NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    delete: Optional[bool] = Field(..., alias="delete")
    cluster: AutomatedActionOpenshiftTriggerCronjobArgumentV1_NamespaceV1_ClusterV1 = Field(..., alias="cluster")


class AutomatedActionOpenshiftTriggerCronjobArgumentV1(ConfiguredBaseModel):
    namespace: AutomatedActionOpenshiftTriggerCronjobArgumentV1_NamespaceV1 = Field(..., alias="namespace")
    cronjob: str = Field(..., alias="cronjob")


class AutomatedActionOpenshiftTriggerCronjobV1(AutomatedActionV1):
    openshift_trigger_cronjob_arguments: list[AutomatedActionOpenshiftTriggerCronjobArgumentV1] = Field(..., alias="openshift_trigger_cronjob_arguments")


class AutomatedActionOpenshiftWorkloadDeleteArgumentV1_NamespaceV1_ClusterV1_DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class AutomatedActionOpenshiftWorkloadDeleteArgumentV1_NamespaceV1_ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    disable: Optional[AutomatedActionOpenshiftWorkloadDeleteArgumentV1_NamespaceV1_ClusterV1_DisableClusterAutomationsV1] = Field(..., alias="disable")


class AutomatedActionOpenshiftWorkloadDeleteArgumentV1_NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    delete: Optional[bool] = Field(..., alias="delete")
    cluster: AutomatedActionOpenshiftWorkloadDeleteArgumentV1_NamespaceV1_ClusterV1 = Field(..., alias="cluster")


class AutomatedActionOpenshiftWorkloadDeleteArgumentV1(ConfiguredBaseModel):
    namespace: AutomatedActionOpenshiftWorkloadDeleteArgumentV1_NamespaceV1 = Field(..., alias="namespace")
    api_version: Optional[str] = Field(..., alias="api_version")
    kind: str = Field(..., alias="kind")
    name: str = Field(..., alias="name")


class AutomatedActionOpenshiftWorkloadDeleteV1(AutomatedActionV1):
    openshift_workload_delete_arguments: list[AutomatedActionOpenshiftWorkloadDeleteArgumentV1] = Field(..., alias="openshift_workload_delete_arguments")


class AutomatedActionOpenshiftWorkloadRestartArgumentV1_NamespaceV1_ClusterV1_DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class AutomatedActionOpenshiftWorkloadRestartArgumentV1_NamespaceV1_ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    disable: Optional[AutomatedActionOpenshiftWorkloadRestartArgumentV1_NamespaceV1_ClusterV1_DisableClusterAutomationsV1] = Field(..., alias="disable")


class AutomatedActionOpenshiftWorkloadRestartArgumentV1_NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    delete: Optional[bool] = Field(..., alias="delete")
    cluster: AutomatedActionOpenshiftWorkloadRestartArgumentV1_NamespaceV1_ClusterV1 = Field(..., alias="cluster")


class AutomatedActionOpenshiftWorkloadRestartArgumentV1(ConfiguredBaseModel):
    namespace: AutomatedActionOpenshiftWorkloadRestartArgumentV1_NamespaceV1 = Field(..., alias="namespace")
    kind: str = Field(..., alias="kind")
    name: str = Field(..., alias="name")


class AutomatedActionOpenshiftWorkloadRestartV1(AutomatedActionV1):
    openshift_workload_restart_arguments: list[AutomatedActionOpenshiftWorkloadRestartArgumentV1] = Field(..., alias="openshift_workload_restart_arguments")


class AutomatedActionsInstanceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    deployment: NamespaceV1 = Field(..., alias="deployment")
    actions: Optional[list[Union[AutomatedActionActionListV1, AutomatedActionExternalResourceFlushElastiCacheV1, AutomatedActionExternalResourceRdsRebootV1, AutomatedActionExternalResourceRdsSnapshotV1, AutomatedActionOpenshiftTriggerCronjobV1, AutomatedActionOpenshiftWorkloadDeleteV1, AutomatedActionOpenshiftWorkloadRestartV1, AutomatedActionV1]]] = Field(..., alias="actions")


class AutomatedActionsInstancesQueryData(ConfiguredBaseModel):
    automated_actions_instances_v1: Optional[list[AutomatedActionsInstanceV1]] = Field(..., alias="automated_actions_instances_v1")


def query(query_func: Callable, **kwargs: Any) -> AutomatedActionsInstancesQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        AutomatedActionsInstancesQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return AutomatedActionsInstancesQueryData(**raw_data)
