"""
Generated by qenerate plugin=pydantic_v2. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    ConfigDict,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.aws_account_sso import AWSAccountSSO


DEFINITION = """
fragment AWSAccountSSO on AWSAccount_v1 {
  name
  uid
  sso
  disable {
    integrations
  }
}

query AwsSamlRolesQuery {
  roles: roles_v1 {
    name
    user_policies {
      name
      policy
      account {
        ...AWSAccountSSO
      }
    }
    aws_groups {
      account {
        ...AWSAccountSSO
      }
      policies
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid'
    )


class AWSUserPolicyV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    policy: Json = Field(..., alias="policy")
    account: AWSAccountSSO = Field(..., alias="account")


class AWSGroupV1(ConfiguredBaseModel):
    account: AWSAccountSSO = Field(..., alias="account")
    policies: Optional[list[str]] = Field(..., alias="policies")


class RoleV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    user_policies: Optional[list[AWSUserPolicyV1]] = Field(..., alias="user_policies")
    aws_groups: Optional[list[AWSGroupV1]] = Field(..., alias="aws_groups")


class AwsSamlRolesQueryQueryData(ConfiguredBaseModel):
    roles: Optional[list[RoleV1]] = Field(..., alias="roles")


def query(query_func: Callable, **kwargs: Any) -> AwsSamlRolesQueryQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        AwsSamlRolesQueryQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return AwsSamlRolesQueryQueryData(**raw_data)
