"""
Generated by qenerate plugin=pydantic_v2. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    ConfigDict,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.aws_vpc_request import VPCRequest


DEFINITION = """
fragment AWSOrganization on AWSOrganization_v1 {
  payerAccount {
    organizationAccountTags
  }
  tags
}

fragment TerraformState on TerraformStateAWS_v1 {
  provider
  bucket
  region
  integrations {
    key
    integration
  }
}

fragment VPCRequest on VPCRequest_v1 {
  identifier
  delete
  account {
    name
    uid
    terraformUsername
    automationToken {
      ...VaultSecret
    }
    supportedDeploymentRegions
    resourcesDefaultRegion
    providerVersion
    terraformState {
      ...TerraformState
    }
    enableDeletion
    deletionApprovals {
      type
      name
      expiration
    }
    organization {
      ...AWSOrganization
    }
  }
  region
  cidr_block {
    networkAddress
  }
  vpc_tags
  subnets {
    private
    public
    availability_zones
    private_subnet_tags
    public_subnet_tags
  }
}

fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query VPCRequest {
  vpc_requests: aws_vpc_request_v1 {
    ...VPCRequest
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid'
    )


class VPCRequestQueryData(ConfiguredBaseModel):
    vpc_requests: Optional[list[VPCRequest]] = Field(..., alias="vpc_requests")


def query(query_func: Callable, **kwargs: Any) -> VPCRequestQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        VPCRequestQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return VPCRequestQueryData(**raw_data)
