"""
Generated by qenerate plugin=pydantic_v2. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    ConfigDict,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.jumphost_common_fields import CommonJumphostFields
from reconcile.gql_definitions.fragments.pipeline_provider_retention import PipelineProviderRetention
from reconcile.gql_definitions.fragments.resource_limits_requirements import ResourceLimitsRequirements
from reconcile.gql_definitions.fragments.resource_requests_requirements import ResourceRequestsRequirements
from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment CommonJumphostFields on ClusterJumpHost_v1 {
  hostname
  knownHosts
  user
  port
  remotePort
  identity {
    ...VaultSecret
  }
}

fragment PipelineProviderRetention on PipelinesProviderRetention_v1 {
  days
  minimum
  maximum
}

fragment ResourceLimitsRequirements on ResourceLimitsRequirements_v1 {
  cpu
  memory
}

fragment ResourceRequestsRequirements on ResourceRequestsRequirements_v1 {
  cpu
  memory
}

fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query PipelineProviders {
  pipelines_providers: pipelines_providers_v1 {
    name
    provider
    ... on PipelinesProviderTekton_v1 {
      defaults {
        retention {
          ...PipelineProviderRetention
        }
        taskTemplates {
          ... on PipelinesProviderTektonObjectTemplate_v1 {
            name
            type
            path
            variables
          }
        }
        pipelineTemplates {
          openshiftSaasDeploy {
            name
            type
            path
            variables
          }
        }
        deployResources {
          requests {
            ...ResourceRequestsRequirements
          }
          limits {
            ...ResourceLimitsRequirements
          }
        }
      }
      namespace {
        name
        path
        clusterAdmin
        app {
          name
          path
        }
        cluster {
          name
          serverUrl
          insecureSkipTLSVerify
          jumpHost {
            ...CommonJumphostFields
          }
          automationToken {
            ...VaultSecret
          }
          clusterAdminAutomationToken {
            ...VaultSecret
          }
          internal
          disable {
            integrations
          }
        }
      }
      retention {
        ...PipelineProviderRetention
      }
      taskTemplates {
        ... on PipelinesProviderTektonObjectTemplate_v1 {
          name
          type
          path
          variables
        }
      }
      pipelineTemplates {
        openshiftSaasDeploy {
          name
          type
          path
          variables
        }
      }
      deployResources {
        requests {
          ...ResourceRequestsRequirements
        }
        limits {
          ...ResourceLimitsRequirements
        }
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid'
    )


class PipelinesProviderV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    provider: str = Field(..., alias="provider")


class PipelinesProviderTektonObjectTemplateV1(ConfiguredBaseModel):
    ...


class PipelinesProviderTektonObjectTemplateV1_PipelinesProviderTektonObjectTemplateV1(PipelinesProviderTektonObjectTemplateV1):
    name: str = Field(..., alias="name")
    q_type: str = Field(..., alias="type")
    path: str = Field(..., alias="path")
    variables: Optional[Json] = Field(..., alias="variables")


class PipelinesProviderPipelineTemplatesV1_PipelinesProviderTektonObjectTemplateV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    q_type: str = Field(..., alias="type")
    path: str = Field(..., alias="path")
    variables: Optional[Json] = Field(..., alias="variables")


class PipelinesProviderPipelineTemplatesV1(ConfiguredBaseModel):
    openshift_saas_deploy: PipelinesProviderPipelineTemplatesV1_PipelinesProviderTektonObjectTemplateV1 = Field(..., alias="openshiftSaasDeploy")


class DeployResourcesV1(ConfiguredBaseModel):
    requests: ResourceRequestsRequirements = Field(..., alias="requests")
    limits: ResourceLimitsRequirements = Field(..., alias="limits")


class PipelinesProviderTektonProviderDefaultsV1(ConfiguredBaseModel):
    retention: PipelineProviderRetention = Field(..., alias="retention")
    task_templates: list[Union[PipelinesProviderTektonObjectTemplateV1_PipelinesProviderTektonObjectTemplateV1, PipelinesProviderTektonObjectTemplateV1]] = Field(..., alias="taskTemplates")
    pipeline_templates: PipelinesProviderPipelineTemplatesV1 = Field(..., alias="pipelineTemplates")
    deploy_resources: Optional[DeployResourcesV1] = Field(..., alias="deployResources")


class AppV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    path: str = Field(..., alias="path")


class DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    server_url: str = Field(..., alias="serverUrl")
    insecure_skip_tls_verify: Optional[bool] = Field(..., alias="insecureSkipTLSVerify")
    jump_host: Optional[CommonJumphostFields] = Field(..., alias="jumpHost")
    automation_token: Optional[VaultSecret] = Field(..., alias="automationToken")
    cluster_admin_automation_token: Optional[VaultSecret] = Field(..., alias="clusterAdminAutomationToken")
    internal: Optional[bool] = Field(..., alias="internal")
    disable: Optional[DisableClusterAutomationsV1] = Field(..., alias="disable")


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    path: str = Field(..., alias="path")
    cluster_admin: Optional[bool] = Field(..., alias="clusterAdmin")
    app: AppV1 = Field(..., alias="app")
    cluster: ClusterV1 = Field(..., alias="cluster")


class PipelinesProviderTektonV1_PipelinesProviderTektonObjectTemplateV1(ConfiguredBaseModel):
    ...


class PipelinesProviderTektonV1_PipelinesProviderTektonObjectTemplateV1_PipelinesProviderTektonObjectTemplateV1(PipelinesProviderTektonV1_PipelinesProviderTektonObjectTemplateV1):
    name: str = Field(..., alias="name")
    q_type: str = Field(..., alias="type")
    path: str = Field(..., alias="path")
    variables: Optional[Json] = Field(..., alias="variables")


class PipelinesProviderTektonV1_PipelinesProviderPipelineTemplatesV1_PipelinesProviderTektonObjectTemplateV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    q_type: str = Field(..., alias="type")
    path: str = Field(..., alias="path")
    variables: Optional[Json] = Field(..., alias="variables")


class PipelinesProviderTektonV1_PipelinesProviderPipelineTemplatesV1(ConfiguredBaseModel):
    openshift_saas_deploy: PipelinesProviderTektonV1_PipelinesProviderPipelineTemplatesV1_PipelinesProviderTektonObjectTemplateV1 = Field(..., alias="openshiftSaasDeploy")


class PipelinesProviderTektonV1_DeployResourcesV1(ConfiguredBaseModel):
    requests: ResourceRequestsRequirements = Field(..., alias="requests")
    limits: ResourceLimitsRequirements = Field(..., alias="limits")


class PipelinesProviderTektonV1(PipelinesProviderV1):
    defaults: PipelinesProviderTektonProviderDefaultsV1 = Field(..., alias="defaults")
    namespace: NamespaceV1 = Field(..., alias="namespace")
    retention: Optional[PipelineProviderRetention] = Field(..., alias="retention")
    task_templates: Optional[list[Union[PipelinesProviderTektonV1_PipelinesProviderTektonObjectTemplateV1_PipelinesProviderTektonObjectTemplateV1, PipelinesProviderTektonV1_PipelinesProviderTektonObjectTemplateV1]]] = Field(..., alias="taskTemplates")
    pipeline_templates: Optional[PipelinesProviderTektonV1_PipelinesProviderPipelineTemplatesV1] = Field(..., alias="pipelineTemplates")
    deploy_resources: Optional[PipelinesProviderTektonV1_DeployResourcesV1] = Field(..., alias="deployResources")


class PipelineProvidersQueryData(ConfiguredBaseModel):
    pipelines_providers: Optional[list[Union[PipelinesProviderTektonV1, PipelinesProviderV1]]] = Field(..., alias="pipelines_providers")


def query(query_func: Callable, **kwargs: Any) -> PipelineProvidersQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        PipelineProvidersQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return PipelineProvidersQueryData(**raw_data)
