"""
Generated by qenerate plugin=pydantic_v2. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    ConfigDict,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.email_service import EmailServiceOwners
from reconcile.gql_definitions.fragments.email_user import EmailUser


DEFINITION = """
fragment EmailServiceOwners on App_v1 {
  serviceOwners {
    email
  }
}

fragment EmailUser on User_v1 {
  org_username
}

query Emails {
  emails: app_interface_emails_v1 {
    name
    subject
    to {
      aliases
      services {
        ...EmailServiceOwners
      }
      clusters {
        name
      }
      namespaces {
        name
      }
      aws_accounts {
        accountOwners {
          email
        }
      }
      roles {
        users {
          ...EmailUser
        }
      }
      users {
        ...EmailUser
      }
    }
    body
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid'
    )


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class OwnerV1(ConfiguredBaseModel):
    email: str = Field(..., alias="email")


class AWSAccountV1(ConfiguredBaseModel):
    account_owners: list[OwnerV1] = Field(..., alias="accountOwners")


class RoleV1(ConfiguredBaseModel):
    users: list[EmailUser] = Field(..., alias="users")


class AppInterfaceEmailAudienceV1(ConfiguredBaseModel):
    aliases: Optional[list[str]] = Field(..., alias="aliases")
    services: Optional[list[EmailServiceOwners]] = Field(..., alias="services")
    clusters: Optional[list[ClusterV1]] = Field(..., alias="clusters")
    namespaces: Optional[list[NamespaceV1]] = Field(..., alias="namespaces")
    aws_accounts: Optional[list[AWSAccountV1]] = Field(..., alias="aws_accounts")
    roles: Optional[list[RoleV1]] = Field(..., alias="roles")
    users: Optional[list[EmailUser]] = Field(..., alias="users")


class AppInterfaceEmailV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    subject: str = Field(..., alias="subject")
    q_to: AppInterfaceEmailAudienceV1 = Field(..., alias="to")
    body: str = Field(..., alias="body")


class EmailsQueryData(ConfiguredBaseModel):
    emails: Optional[list[AppInterfaceEmailV1]] = Field(..., alias="emails")


def query(query_func: Callable, **kwargs: Any) -> EmailsQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        EmailsQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return EmailsQueryData(**raw_data)
