"""
Generated by qenerate plugin=pydantic_v2. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    ConfigDict,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query FleetLabelSpecs {
  fleet_labels_specs: fleet_labels_specs_v1 {
    name
    path
    managedSubscriptionLabelPrefix
    dryRunLabelSynchronization
    ocmEnv {
      name
      url
      accessTokenClientId
      accessTokenClientSecret {
        ...VaultSecret
      }
      accessTokenUrl
    }
    labelDefaults {
      name
      matchSubscriptionLabels
      subscriptionLabelTemplate {
        path {
          content
        }
        type
        variables
      }
    }
    clusters {
      name
      serverUrl
      subscriptionId
      clusterId
      subscriptionLabels
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid'
    )


class OpenShiftClusterManagerEnvironmentV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    url: str = Field(..., alias="url")
    access_token_client_id: str = Field(..., alias="accessTokenClientId")
    access_token_client_secret: VaultSecret = Field(..., alias="accessTokenClientSecret")
    access_token_url: str = Field(..., alias="accessTokenUrl")


class ResourceV1(ConfiguredBaseModel):
    content: str = Field(..., alias="content")


class FleetSubscriptionLabelTemplateV1(ConfiguredBaseModel):
    path: Optional[ResourceV1] = Field(..., alias="path")
    q_type: Optional[str] = Field(..., alias="type")
    variables: Optional[Json] = Field(..., alias="variables")


class FleetLabelDefaultV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    match_subscription_labels: Json = Field(..., alias="matchSubscriptionLabels")
    subscription_label_template: FleetSubscriptionLabelTemplateV1 = Field(..., alias="subscriptionLabelTemplate")


class FleetClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    server_url: str = Field(..., alias="serverUrl")
    subscription_id: str = Field(..., alias="subscriptionId")
    cluster_id: str = Field(..., alias="clusterId")
    subscription_labels: Json = Field(..., alias="subscriptionLabels")


class FleetLabelsSpecV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    path: str = Field(..., alias="path")
    managed_subscription_label_prefix: str = Field(..., alias="managedSubscriptionLabelPrefix")
    dry_run_label_synchronization: Optional[bool] = Field(..., alias="dryRunLabelSynchronization")
    ocm_env: OpenShiftClusterManagerEnvironmentV1 = Field(..., alias="ocmEnv")
    label_defaults: list[FleetLabelDefaultV1] = Field(..., alias="labelDefaults")
    clusters: list[FleetClusterV1] = Field(..., alias="clusters")


class FleetLabelSpecsQueryData(ConfiguredBaseModel):
    fleet_labels_specs: Optional[list[FleetLabelsSpecV1]] = Field(..., alias="fleet_labels_specs")


def query(query_func: Callable, **kwargs: Any) -> FleetLabelSpecsQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        FleetLabelSpecsQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return FleetLabelSpecsQueryData(**raw_data)
