"""
Generated by qenerate plugin=pydantic_v2. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    ConfigDict,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query TerraformCloudflareAccounts {
  accounts: cloudflare_accounts_v1 {
    name
    description
    providerVersion
    apiCredentials {
      ...VaultSecret
    }
    terraformStateAccount {
      name
      automationToken {
        ...VaultSecret
      }
      terraformState {
        provider
        bucket
        region
        integrations {
          integration
          key
        }
      }
    }
    deletionApprovals {
      expiration
      name
      type
    }
    enforceTwofactor
    type
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    model_config = ConfigDict(
        extra='forbid'
    )


class AWSTerraformStateIntegrationsV1(ConfiguredBaseModel):
    integration: str = Field(..., alias="integration")
    key: str = Field(..., alias="key")


class TerraformStateAWSV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")
    bucket: str = Field(..., alias="bucket")
    region: str = Field(..., alias="region")
    integrations: list[AWSTerraformStateIntegrationsV1] = Field(..., alias="integrations")


class AWSAccountV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    automation_token: VaultSecret = Field(..., alias="automationToken")
    terraform_state: Optional[TerraformStateAWSV1] = Field(..., alias="terraformState")


class DeletionApprovalV1(ConfiguredBaseModel):
    expiration: str = Field(..., alias="expiration")
    name: str = Field(..., alias="name")
    q_type: str = Field(..., alias="type")


class CloudflareAccountV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    description: Optional[str] = Field(..., alias="description")
    provider_version: str = Field(..., alias="providerVersion")
    api_credentials: VaultSecret = Field(..., alias="apiCredentials")
    terraform_state_account: AWSAccountV1 = Field(..., alias="terraformStateAccount")
    deletion_approvals: Optional[list[DeletionApprovalV1]] = Field(..., alias="deletionApprovals")
    enforce_twofactor: Optional[bool] = Field(..., alias="enforceTwofactor")
    q_type: Optional[str] = Field(..., alias="type")


class TerraformCloudflareAccountsQueryData(ConfiguredBaseModel):
    accounts: Optional[list[CloudflareAccountV1]] = Field(..., alias="accounts")


def query(query_func: Callable, **kwargs: Any) -> TerraformCloudflareAccountsQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        TerraformCloudflareAccountsQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return TerraformCloudflareAccountsQueryData(**raw_data)
