# mypy-boto3-lex-models

Type annotations for
[boto3.LexModelBuildingService 1.10.47](https://boto3.amazonaws.com/v1/documentation/api/1.10.47/reference/services/lex-models.html#LexModelBuildingService) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

More information can be found [here](https://vemel.github.io/mypy_boto3/).

- [mypy-boto3-lex-models](#mypy-boto3-lex-models)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `LexModelBuildingService` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-lex-models]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import lex_models
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_lex_models as lex_models

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("lex-models")
client: lex_models.LexModelBuildingServiceClient = boto3.client("lex-models")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: lex_models.LexModelBuildingServiceClient = session.client("lex-models")


# Paginators need type annotation on creation
get_bot_aliases_paginator: lex_models.GetBotAliasesPaginator = client.get_paginator("get_bot_aliases")
get_bot_channel_associations_paginator: lex_models.GetBotChannelAssociationsPaginator = client.get_paginator("get_bot_channel_associations")
get_bot_versions_paginator: lex_models.GetBotVersionsPaginator = client.get_paginator("get_bot_versions")
get_bots_paginator: lex_models.GetBotsPaginator = client.get_paginator("get_bots")
get_builtin_intents_paginator: lex_models.GetBuiltinIntentsPaginator = client.get_paginator("get_builtin_intents")
get_builtin_slot_types_paginator: lex_models.GetBuiltinSlotTypesPaginator = client.get_paginator("get_builtin_slot_types")
get_intent_versions_paginator: lex_models.GetIntentVersionsPaginator = client.get_paginator("get_intent_versions")
get_intents_paginator: lex_models.GetIntentsPaginator = client.get_paginator("get_intents")
get_slot_type_versions_paginator: lex_models.GetSlotTypeVersionsPaginator = client.get_paginator("get_slot_type_versions")
get_slot_types_paginator: lex_models.GetSlotTypesPaginator = client.get_paginator("get_slot_types")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.