# Contributing to LinAIx

Thank you for considering contributing to LinAIx! We welcome contributions from the community to improve this Linux command assistant powered by the Google Gemini API.

## How to Contribute
1. **Fork the Repository**
   - Fork the repo on GitHub (https://github.com/AdirAli/linaix).
2. **Clone Your Fork**
   ```bash
   git clone https://github.com/AdirAli/linaix.git
   cd linaix
   ```
3. **Create a Branch**
   ```bash
   git checkout -b feature/your-feature-name
   ```
4. **Make Changes**
   - Follow the coding style (Python 3.6+ compatible, PEP 8 recommended).
   - Add or update documentation (e.g., `README.md`) as needed.
   - Include tests if applicable (though not currently required).
5. **Commit Changes**
   ```bash
   git commit -m "Add your message here"
   ```
6. **Push to GitHub**
   ```bash
   git push origin feature/your-feature-name
   ```
7. **Submit a Pull Request**
   - Open a PR from your branch to the main repository's `main` branch.
   - Describe your changes, including what was added or fixed and why.

## Guidelines
- Ensure your code works with the existing setup (Python 3.6+ with `google-generativeai` and `prompt_toolkit`).
- Add or update documentation to reflect your changes.
- Test your changes locally before submitting (e.g., run `./linaix.py --interactive`).
- Follow the MIT License terms included in the [LICENSE](LICENSE) file.
- Keep the project simple and focused on its core purpose, with enhancements like terminal control or additional features added as optional modules.

## Reporting Issues
- Use the GitHub Issues tab to report bugs or suggest features.
- Provide detailed reproduction steps, including:
  - The command or task entered.
  - The expected behavior.
  - The actual behavior or error message.
- Include your operating system and Python version if relevant.

## Community
- Join the discussion on GitHub via Issues or Discussions
- Reach out via email at adiraliyerima@gmail.com for direct communication.
- Share your ideas or questions with the community to collaborate on features.

## Future Enhancements
- We’re open to adding features like:
  - Terminal control in a new window 
  - Error logging or command history persistence.
  - Support for additional AI models or APIs. 
- Feel free to propose these or other ideas in a pull request or issue!

## Acknowledgments
Your contributions help make LinAIx a valuable tool for the Linux community. Thank you for your support!

