# Hapax Python SDK Examples

This directory contains example applications demonstrating various features of the Hapax Python SDK.

## Prerequisites

Before running the examples:

1. Install dependencies:
```bash
pip install hapax-py openai
```

2. Set up your OpenAI API key:
```bash
export OPENAI_API_KEY=your-api-key-here
```

3. Start the observability stack:
```bash
# From the project root
docker compose up -d
```

## Available Examples

### 1. Simple Completion (`simple_completion.py`)

A basic example demonstrating:
- LLM function decoration with `@llm_function`
- OpenLit trace initialization
- Haiku generation with GPT-3.5
- Basic trace attributes

```bash
uv run simple_completion.py
```

Key concepts:
- Single-level tracing
- Basic metadata attributes
- Simple prompt engineering
- Error handling

### 2. Evaluation Example (`evaluation_example.py`)

An advanced example showing:
- Text generation with analysis
- Nested traces for complex operations
- Rich metadata collection
- Multiple LLM calls within a single trace

```bash
uv run evaluation_example.py
```

Key concepts:
- Multi-level tracing
- Detailed metadata attributes
- Content analysis
- Context-aware evaluation

## Trace Visualization

After running the examples:

1. Open Jaeger UI:
   - URL: http://localhost:16687
   
2. Search for traces:
   - Service: hapax-py
   - Operation: Various (e.g., "haiku_generation", "text_generation")

3. Explore trace details:
   - View trace hierarchy
   - Examine metadata attributes
   - Analyze timing information

## Common Attributes

Both examples use these standard attributes:

```python
trace.set_metadata({
    # Provider information
    "gen_ai.system": "openai",
    "gen_ai.request.model": "gpt-3.5-turbo",
    
    # Operation details
    "gen_ai.operation.name": "text_generation",
    "gen_ai.application_name": "hapax-example",
    
    # Request/Response
    "gen_ai.prompt": prompt,
    "gen_ai.completion": result
})
```

## Known Issues

1. Langchain warning (can be ignored):
```
Failed to instrument langchain: No module named 'langchain_community'
```

2. Metrics warning (doesn't affect tracing):
```
OpenLIT metrics setup failed. Metrics will not be available
```

## Next Steps

After exploring these examples, you can:
1. Add tracing to your own LLM functions
2. Customize trace attributes for your use case
3. Build more complex applications with nested traces
4. Integrate with your existing monitoring infrastructure
