"""
Minimal example to demonstrate Hapax SDK usage
"""

import os
import openai
from hapax_py import llm_function, HapaxClient

# Set your OpenAI key
openai.api_key = os.getenv("OPENAI_API_KEY")

@llm_function(
    name="hello_world",
    model="gpt-3.5-turbo",
    provider="openai"
)
def say_hello(name: str) -> str:
    """Simple function that generates a greeting"""
    response = openai.ChatCompletion.create(
        model="gpt-3.5-turbo",
        messages=[
            {"role": "user", "content": f"Say hello to {name} in a creative way"}
        ]
    )
    return response.choices[0].message.content

def main():
    # 1. Create Hapax client
    print("Creating Hapax client...")
    client = HapaxClient(
        gateway_url=os.getenv("HAPAX_GATEWAY_URL", "http://localhost:8080")
    )
    
    # 2. Deploy the function
    print("\nDeploying function to Hapax Gateway...")
    deployment = client.deploy_function(say_hello)
    print(f"Deployment info: {deployment}")
    
    # 3. Test the function
    print("\nTesting the function...")
    result = say_hello("Alice")
    print(f"\nResult: {result}")
    
    print("\nCheck your OpenLIT dashboard to see the observability data!")

if __name__ == "__main__":
    main()
