"""
Mock metrics collection for demonstration
"""

import random
import time
from typing import Dict, Any
import threading

class MetricsCollector:
    """Collects mock metrics for demonstration"""
    
    def __init__(self):
        self._metrics = {}
        self._lock = threading.Lock()
        self._start_time = time.time()
        
        # Start background collection
        self._start_collection()
    
    def _start_collection(self):
        """Start background metrics collection"""
        def collect_metrics():
            while True:
                with self._lock:
                    elapsed = time.time() - self._start_time
                    # Generate some realistic-looking mock metrics
                    self._metrics.update({
                        "requests_per_second": random.uniform(0.5, 2.0),
                        "average_latency": random.uniform(200, 800),
                        "total_tokens": int(elapsed * random.uniform(5, 15)),
                        "estimated_cost": elapsed * random.uniform(0.0001, 0.001),
                        "success_rate": random.uniform(0.95, 1.0),
                        "cache_hit_rate": random.uniform(0.1, 0.3),
                    })
                time.sleep(0.25)
        
        thread = threading.Thread(target=collect_metrics, daemon=True)
        thread.start()
    
    def get_latest(self) -> Dict[str, Any]:
        """Get the latest metrics"""
        with self._lock:
            return self._metrics.copy()
