"""
Mock Hapax server for demonstration
"""

import os
import signal
import subprocess
import time
from pathlib import Path
from typing import Optional

class HapaxServer:
    """Mock Hapax server for demonstration"""
    
    def __init__(
        self,
        hapax_path: Optional[str] = None,
        port: int = 8080,
        config_path: Optional[str] = None
    ):
        """Initialize mock server"""
        self.port = port
        self.process = None
        
    def start(self) -> None:
        """Start the mock server"""
        # For demo, we'll just pretend the server is running
        pass

    def stop(self) -> None:
        """Stop the mock server"""
        pass

    def __enter__(self):
        """Start server when entering context"""
        self.start()
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        """Stop server when exiting context"""
        self.stop()
