# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CredentialsArgs', 'Credentials']

@pulumi.input_type
class CredentialsArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 iamrole: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Credentials resource.
        :param pulumi.Input[_builtins.str] account_id: The ID of the account associated with your token.
        :param pulumi.Input[_builtins.str] iamrole: Provide the IAM Role ARN connected to another AWS account 922761411349 and with the latest Spot Policy - https://docs.spot.io/administration/api/spot-policy-in-aws
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "iamrole", iamrole)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the account associated with your token.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def iamrole(self) -> pulumi.Input[_builtins.str]:
        """
        Provide the IAM Role ARN connected to another AWS account 922761411349 and with the latest Spot Policy - https://docs.spot.io/administration/api/spot-policy-in-aws
        """
        return pulumi.get(self, "iamrole")

    @iamrole.setter
    def iamrole(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iamrole", value)


@pulumi.input_type
class _CredentialsState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iamrole: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Credentials resources.
        :param pulumi.Input[_builtins.str] account_id: The ID of the account associated with your token.
        :param pulumi.Input[_builtins.str] iamrole: Provide the IAM Role ARN connected to another AWS account 922761411349 and with the latest Spot Policy - https://docs.spot.io/administration/api/spot-policy-in-aws
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if iamrole is not None:
            pulumi.set(__self__, "iamrole", iamrole)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the account associated with your token.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def iamrole(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provide the IAM Role ARN connected to another AWS account 922761411349 and with the latest Spot Policy - https://docs.spot.io/administration/api/spot-policy-in-aws
        """
        return pulumi.get(self, "iamrole")

    @iamrole.setter
    def iamrole(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iamrole", value)


@pulumi.type_token("spotinst:aws/credentials:Credentials")
class Credentials(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iamrole: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Spotinst credential AWS resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        # set credential AWS
        credential = spotinst.aws.Credentials("credential",
            iamrole="arn:aws:iam::1234567890:role/Spot_Iam_Role",
            account_id="act-123456")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The ID of the account associated with your token.
        :param pulumi.Input[_builtins.str] iamrole: Provide the IAM Role ARN connected to another AWS account 922761411349 and with the latest Spot Policy - https://docs.spot.io/administration/api/spot-policy-in-aws
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CredentialsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Spotinst credential AWS resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        # set credential AWS
        credential = spotinst.aws.Credentials("credential",
            iamrole="arn:aws:iam::1234567890:role/Spot_Iam_Role",
            account_id="act-123456")
        ```

        :param str resource_name: The name of the resource.
        :param CredentialsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CredentialsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iamrole: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CredentialsArgs.__new__(CredentialsArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if iamrole is None and not opts.urn:
                raise TypeError("Missing required property 'iamrole'")
            __props__.__dict__["iamrole"] = iamrole
        super(Credentials, __self__).__init__(
            'spotinst:aws/credentials:Credentials',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            iamrole: Optional[pulumi.Input[_builtins.str]] = None) -> 'Credentials':
        """
        Get an existing Credentials resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The ID of the account associated with your token.
        :param pulumi.Input[_builtins.str] iamrole: Provide the IAM Role ARN connected to another AWS account 922761411349 and with the latest Spot Policy - https://docs.spot.io/administration/api/spot-policy-in-aws
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CredentialsState.__new__(_CredentialsState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["iamrole"] = iamrole
        return Credentials(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the account associated with your token.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def iamrole(self) -> pulumi.Output[_builtins.str]:
        """
        Provide the IAM Role ARN connected to another AWS account 922761411349 and with the latest Spot Policy - https://docs.spot.io/administration/api/spot-policy-in-aws
        """
        return pulumi.get(self, "iamrole")

