# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OceanNpArgs', 'OceanNp']

@pulumi.input_type
class OceanNpArgs:
    def __init__(__self__, *,
                 aks_cluster_name: pulumi.Input[_builtins.str],
                 aks_infrastructure_resource_group_name: pulumi.Input[_builtins.str],
                 aks_region: pulumi.Input[_builtins.str],
                 aks_resource_group_name: pulumi.Input[_builtins.str],
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 controller_cluster_id: pulumi.Input[_builtins.str],
                 autoscaler: Optional[pulumi.Input['OceanNpAutoscalerArgs']] = None,
                 enable_node_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input['OceanNpFiltersArgs']] = None,
                 headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpHeadroomArgs']]]] = None,
                 health: Optional[pulumi.Input['OceanNpHealthArgs']] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpLinuxOsConfigArgs']]]] = None,
                 logging: Optional[pulumi.Input['OceanNpLoggingArgs']] = None,
                 max_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 min_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scheduling: Optional[pulumi.Input['OceanNpSchedulingArgs']] = None,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpTaintArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanNpUpdatePolicyArgs']] = None,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vng_template_scheduling: Optional[pulumi.Input['OceanNpVngTemplateSchedulingArgs']] = None):
        """
        The set of arguments for constructing a OceanNp resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        :param pulumi.Input[_builtins.str] controller_cluster_id: Enter a unique Ocean cluster identifier. Cannot be updated. This needs to match with string that was used to install the controller in the cluster, typically clusterName + 8 digit string.
        :param pulumi.Input['OceanNpAutoscalerArgs'] autoscaler: The Ocean Kubernetes Autoscaler object.
        :param pulumi.Input[_builtins.bool] enable_node_public_ip: Enable node public IP.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: If no spot VM markets are available, enable Ocean to launch regular (pay-as-you-go) nodes instead.
        :param pulumi.Input['OceanNpFiltersArgs'] filters: Filters for the VM sizes that can be launched from the virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpHeadroomArgs']]] headrooms: Specify the custom headroom per VNG. Provide a list of headroom objects.
        :param pulumi.Input['OceanNpHealthArgs'] health: The Ocean AKS Health object.
        :param pulumi.Input[_builtins.str] kubernetes_version: The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: An array of labels to add to the virtual node group. Only custom user labels are allowed, and not [Kubernetes well-known labels](https://kubernetes.io/docs/reference/labels-annotations-taints/) or [ Azure AKS labels](https://learn.microsoft.com/en-us/azure/aks/use-labels) or [Spot labels](https://docs.spot.io/ocean/features/labels-and-taints?id=spot-labels).
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpLinuxOsConfigArgs']]] linux_os_configs: Custom Linux OS configuration.
        :param pulumi.Input['OceanNpLoggingArgs'] logging: The Ocean AKS Logging Object.
        :param pulumi.Input[_builtins.int] max_count: Maximum node count limit.
        :param pulumi.Input[_builtins.int] max_pods_per_node: The maximum number of pods per node in the node pools.
        :param pulumi.Input[_builtins.int] min_count: Minimum node count limit.
        :param pulumi.Input[_builtins.str] name: Add a name for the Ocean cluster.
        :param pulumi.Input[_builtins.int] os_disk_size_gb: The size of the OS disk in GB.
        :param pulumi.Input[_builtins.str] os_disk_type: The type of the OS disk.
        :param pulumi.Input[_builtins.str] os_sku: The OS SKU of the OS type. Must correlate with the os type.
        :param pulumi.Input[_builtins.str] os_type: The OS type of the OS disk. Can't be modified once set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_subnet_ids: The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        :param pulumi.Input[_builtins.int] spot_percentage: Percentage of spot VMs to maintain.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpTaintArgs']]] taints: Add taints to a virtual node group. Only custom user taints are allowed, and not [Kubernetes well-known taints](https://kubernetes.io/docs/reference/labels-annotations-taints/) or Azure AKS [ScaleSetPrioirty (Spot VM) taint](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool). For all Spot VMs, AKS injects a taint kubernetes.azure.com/scalesetpriority=spot:NoSchedule, to ensure that only workloads that can handle interruptions are scheduled on Spot nodes. To [schedule a pod to run on Spot node](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool#schedule-a-pod-to-run-on-the-spot-node), add a toleration but dont include the nodeAffinity (not supported for Spot Ocean), this will prevent the pod from being scheduled using Spot Ocean.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vnet_subnet_ids: The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        :param pulumi.Input['OceanNpVngTemplateSchedulingArgs'] vng_template_scheduling: An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        pulumi.set(__self__, "aks_cluster_name", aks_cluster_name)
        pulumi.set(__self__, "aks_infrastructure_resource_group_name", aks_infrastructure_resource_group_name)
        pulumi.set(__self__, "aks_region", aks_region)
        pulumi.set(__self__, "aks_resource_group_name", aks_resource_group_name)
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "controller_cluster_id", controller_cluster_id)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if headrooms is not None:
            pulumi.set(__self__, "headrooms", headrooms)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_os_configs is not None:
            pulumi.set(__self__, "linux_os_configs", linux_os_configs)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pod_subnet_ids is not None:
            pulumi.set(__self__, "pod_subnet_ids", pod_subnet_ids)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if vnet_subnet_ids is not None:
            pulumi.set(__self__, "vnet_subnet_ids", vnet_subnet_ids)
        if vng_template_scheduling is not None:
            pulumi.set(__self__, "vng_template_scheduling", vng_template_scheduling)

    @_builtins.property
    @pulumi.getter(name="aksClusterName")
    def aks_cluster_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "aks_cluster_name")

    @aks_cluster_name.setter
    def aks_cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aks_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="aksInfrastructureResourceGroupName")
    def aks_infrastructure_resource_group_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "aks_infrastructure_resource_group_name")

    @aks_infrastructure_resource_group_name.setter
    def aks_infrastructure_resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aks_infrastructure_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="aksRegion")
    def aks_region(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "aks_region")

    @aks_region.setter
    def aks_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aks_region", value)

    @_builtins.property
    @pulumi.getter(name="aksResourceGroupName")
    def aks_resource_group_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "aks_resource_group_name")

    @aks_resource_group_name.setter
    def aks_resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "aks_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="controllerClusterId")
    def controller_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        Enter a unique Ocean cluster identifier. Cannot be updated. This needs to match with string that was used to install the controller in the cluster, typically clusterName + 8 digit string.
        """
        return pulumi.get(self, "controller_cluster_id")

    @controller_cluster_id.setter
    def controller_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "controller_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['OceanNpAutoscalerArgs']]:
        """
        The Ocean Kubernetes Autoscaler object.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['OceanNpAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @_builtins.property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable node public IP.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If no spot VM markets are available, enable Ocean to launch regular (pay-as-you-go) nodes instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanNpFiltersArgs']]:
        """
        Filters for the VM sizes that can be launched from the virtual node group.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanNpFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter
    def headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpHeadroomArgs']]]]:
        """
        Specify the custom headroom per VNG. Provide a list of headroom objects.
        """
        return pulumi.get(self, "headrooms")

    @headrooms.setter
    def headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpHeadroomArgs']]]]):
        pulumi.set(self, "headrooms", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input['OceanNpHealthArgs']]:
        """
        The Ocean AKS Health object.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input['OceanNpHealthArgs']]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An array of labels to add to the virtual node group. Only custom user labels are allowed, and not [Kubernetes well-known labels](https://kubernetes.io/docs/reference/labels-annotations-taints/) or [ Azure AKS labels](https://learn.microsoft.com/en-us/azure/aks/use-labels) or [Spot labels](https://docs.spot.io/ocean/features/labels-and-taints?id=spot-labels).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="linuxOsConfigs")
    def linux_os_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpLinuxOsConfigArgs']]]]:
        """
        Custom Linux OS configuration.
        """
        return pulumi.get(self, "linux_os_configs")

    @linux_os_configs.setter
    def linux_os_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpLinuxOsConfigArgs']]]]):
        pulumi.set(self, "linux_os_configs", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['OceanNpLoggingArgs']]:
        """
        The Ocean AKS Logging Object.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['OceanNpLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum node count limit.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_count", value)

    @_builtins.property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of pods per node in the node pools.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @_builtins.property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum node count limit.
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add a name for the Ocean cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the OS disk in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the OS disk.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OS SKU of the OS type. Must correlate with the os type.
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_sku", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OS type of the OS disk. Can't be modified once set.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "pod_subnet_ids")

    @pod_subnet_ids.setter
    def pod_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pod_subnet_ids", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['OceanNpSchedulingArgs']]:
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['OceanNpSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Percentage of spot VMs to maintain.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_percentage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpTaintArgs']]]]:
        """
        Add taints to a virtual node group. Only custom user taints are allowed, and not [Kubernetes well-known taints](https://kubernetes.io/docs/reference/labels-annotations-taints/) or Azure AKS [ScaleSetPrioirty (Spot VM) taint](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool). For all Spot VMs, AKS injects a taint kubernetes.azure.com/scalesetpriority=spot:NoSchedule, to ensure that only workloads that can handle interruptions are scheduled on Spot nodes. To [schedule a pod to run on Spot node](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool#schedule-a-pod-to-run-on-the-spot-node), add a toleration but dont include the nodeAffinity (not supported for Spot Ocean), this will prevent the pod from being scheduled using Spot Ocean.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanNpUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanNpUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @_builtins.property
    @pulumi.getter(name="vnetSubnetIds")
    def vnet_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "vnet_subnet_ids")

    @vnet_subnet_ids.setter
    def vnet_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vnet_subnet_ids", value)

    @_builtins.property
    @pulumi.getter(name="vngTemplateScheduling")
    def vng_template_scheduling(self) -> Optional[pulumi.Input['OceanNpVngTemplateSchedulingArgs']]:
        """
        An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        return pulumi.get(self, "vng_template_scheduling")

    @vng_template_scheduling.setter
    def vng_template_scheduling(self, value: Optional[pulumi.Input['OceanNpVngTemplateSchedulingArgs']]):
        pulumi.set(self, "vng_template_scheduling", value)


@pulumi.input_type
class _OceanNpState:
    def __init__(__self__, *,
                 aks_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_region: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 autoscaler: Optional[pulumi.Input['OceanNpAutoscalerArgs']] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input['OceanNpFiltersArgs']] = None,
                 headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpHeadroomArgs']]]] = None,
                 health: Optional[pulumi.Input['OceanNpHealthArgs']] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpLinuxOsConfigArgs']]]] = None,
                 logging: Optional[pulumi.Input['OceanNpLoggingArgs']] = None,
                 max_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 min_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scheduling: Optional[pulumi.Input['OceanNpSchedulingArgs']] = None,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpTaintArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanNpUpdatePolicyArgs']] = None,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vng_template_scheduling: Optional[pulumi.Input['OceanNpVngTemplateSchedulingArgs']] = None):
        """
        Input properties used for looking up and filtering OceanNp resources.
        :param pulumi.Input['OceanNpAutoscalerArgs'] autoscaler: The Ocean Kubernetes Autoscaler object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        :param pulumi.Input[_builtins.str] controller_cluster_id: Enter a unique Ocean cluster identifier. Cannot be updated. This needs to match with string that was used to install the controller in the cluster, typically clusterName + 8 digit string.
        :param pulumi.Input[_builtins.bool] enable_node_public_ip: Enable node public IP.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: If no spot VM markets are available, enable Ocean to launch regular (pay-as-you-go) nodes instead.
        :param pulumi.Input['OceanNpFiltersArgs'] filters: Filters for the VM sizes that can be launched from the virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpHeadroomArgs']]] headrooms: Specify the custom headroom per VNG. Provide a list of headroom objects.
        :param pulumi.Input['OceanNpHealthArgs'] health: The Ocean AKS Health object.
        :param pulumi.Input[_builtins.str] kubernetes_version: The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: An array of labels to add to the virtual node group. Only custom user labels are allowed, and not [Kubernetes well-known labels](https://kubernetes.io/docs/reference/labels-annotations-taints/) or [ Azure AKS labels](https://learn.microsoft.com/en-us/azure/aks/use-labels) or [Spot labels](https://docs.spot.io/ocean/features/labels-and-taints?id=spot-labels).
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpLinuxOsConfigArgs']]] linux_os_configs: Custom Linux OS configuration.
        :param pulumi.Input['OceanNpLoggingArgs'] logging: The Ocean AKS Logging Object.
        :param pulumi.Input[_builtins.int] max_count: Maximum node count limit.
        :param pulumi.Input[_builtins.int] max_pods_per_node: The maximum number of pods per node in the node pools.
        :param pulumi.Input[_builtins.int] min_count: Minimum node count limit.
        :param pulumi.Input[_builtins.str] name: Add a name for the Ocean cluster.
        :param pulumi.Input[_builtins.int] os_disk_size_gb: The size of the OS disk in GB.
        :param pulumi.Input[_builtins.str] os_disk_type: The type of the OS disk.
        :param pulumi.Input[_builtins.str] os_sku: The OS SKU of the OS type. Must correlate with the os type.
        :param pulumi.Input[_builtins.str] os_type: The OS type of the OS disk. Can't be modified once set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_subnet_ids: The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        :param pulumi.Input[_builtins.int] spot_percentage: Percentage of spot VMs to maintain.
        :param pulumi.Input[Sequence[pulumi.Input['OceanNpTaintArgs']]] taints: Add taints to a virtual node group. Only custom user taints are allowed, and not [Kubernetes well-known taints](https://kubernetes.io/docs/reference/labels-annotations-taints/) or Azure AKS [ScaleSetPrioirty (Spot VM) taint](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool). For all Spot VMs, AKS injects a taint kubernetes.azure.com/scalesetpriority=spot:NoSchedule, to ensure that only workloads that can handle interruptions are scheduled on Spot nodes. To [schedule a pod to run on Spot node](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool#schedule-a-pod-to-run-on-the-spot-node), add a toleration but dont include the nodeAffinity (not supported for Spot Ocean), this will prevent the pod from being scheduled using Spot Ocean.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vnet_subnet_ids: The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        :param pulumi.Input['OceanNpVngTemplateSchedulingArgs'] vng_template_scheduling: An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        if aks_cluster_name is not None:
            pulumi.set(__self__, "aks_cluster_name", aks_cluster_name)
        if aks_infrastructure_resource_group_name is not None:
            pulumi.set(__self__, "aks_infrastructure_resource_group_name", aks_infrastructure_resource_group_name)
        if aks_region is not None:
            pulumi.set(__self__, "aks_region", aks_region)
        if aks_resource_group_name is not None:
            pulumi.set(__self__, "aks_resource_group_name", aks_resource_group_name)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if controller_cluster_id is not None:
            pulumi.set(__self__, "controller_cluster_id", controller_cluster_id)
        if enable_node_public_ip is not None:
            pulumi.set(__self__, "enable_node_public_ip", enable_node_public_ip)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if headrooms is not None:
            pulumi.set(__self__, "headrooms", headrooms)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linux_os_configs is not None:
            pulumi.set(__self__, "linux_os_configs", linux_os_configs)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if max_count is not None:
            pulumi.set(__self__, "max_count", max_count)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if min_count is not None:
            pulumi.set(__self__, "min_count", min_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_disk_size_gb is not None:
            pulumi.set(__self__, "os_disk_size_gb", os_disk_size_gb)
        if os_disk_type is not None:
            pulumi.set(__self__, "os_disk_type", os_disk_type)
        if os_sku is not None:
            pulumi.set(__self__, "os_sku", os_sku)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if pod_subnet_ids is not None:
            pulumi.set(__self__, "pod_subnet_ids", pod_subnet_ids)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if vnet_subnet_ids is not None:
            pulumi.set(__self__, "vnet_subnet_ids", vnet_subnet_ids)
        if vng_template_scheduling is not None:
            pulumi.set(__self__, "vng_template_scheduling", vng_template_scheduling)

    @_builtins.property
    @pulumi.getter(name="aksClusterName")
    def aks_cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aks_cluster_name")

    @aks_cluster_name.setter
    def aks_cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aks_cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="aksInfrastructureResourceGroupName")
    def aks_infrastructure_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aks_infrastructure_resource_group_name")

    @aks_infrastructure_resource_group_name.setter
    def aks_infrastructure_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aks_infrastructure_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="aksRegion")
    def aks_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aks_region")

    @aks_region.setter
    def aks_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aks_region", value)

    @_builtins.property
    @pulumi.getter(name="aksResourceGroupName")
    def aks_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "aks_resource_group_name")

    @aks_resource_group_name.setter
    def aks_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "aks_resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['OceanNpAutoscalerArgs']]:
        """
        The Ocean Kubernetes Autoscaler object.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['OceanNpAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="controllerClusterId")
    def controller_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enter a unique Ocean cluster identifier. Cannot be updated. This needs to match with string that was used to install the controller in the cluster, typically clusterName + 8 digit string.
        """
        return pulumi.get(self, "controller_cluster_id")

    @controller_cluster_id.setter
    def controller_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "controller_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable node public IP.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @enable_node_public_ip.setter
    def enable_node_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_node_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If no spot VM markets are available, enable Ocean to launch regular (pay-as-you-go) nodes instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanNpFiltersArgs']]:
        """
        Filters for the VM sizes that can be launched from the virtual node group.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanNpFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter
    def headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpHeadroomArgs']]]]:
        """
        Specify the custom headroom per VNG. Provide a list of headroom objects.
        """
        return pulumi.get(self, "headrooms")

    @headrooms.setter
    def headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpHeadroomArgs']]]]):
        pulumi.set(self, "headrooms", value)

    @_builtins.property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input['OceanNpHealthArgs']]:
        """
        The Ocean AKS Health object.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input['OceanNpHealthArgs']]):
        pulumi.set(self, "health", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        An array of labels to add to the virtual node group. Only custom user labels are allowed, and not [Kubernetes well-known labels](https://kubernetes.io/docs/reference/labels-annotations-taints/) or [ Azure AKS labels](https://learn.microsoft.com/en-us/azure/aks/use-labels) or [Spot labels](https://docs.spot.io/ocean/features/labels-and-taints?id=spot-labels).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="linuxOsConfigs")
    def linux_os_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpLinuxOsConfigArgs']]]]:
        """
        Custom Linux OS configuration.
        """
        return pulumi.get(self, "linux_os_configs")

    @linux_os_configs.setter
    def linux_os_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpLinuxOsConfigArgs']]]]):
        pulumi.set(self, "linux_os_configs", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['OceanNpLoggingArgs']]:
        """
        The Ocean AKS Logging Object.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['OceanNpLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum node count limit.
        """
        return pulumi.get(self, "max_count")

    @max_count.setter
    def max_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_count", value)

    @_builtins.property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of pods per node in the node pools.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @_builtins.property
    @pulumi.getter(name="minCount")
    def min_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum node count limit.
        """
        return pulumi.get(self, "min_count")

    @min_count.setter
    def min_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Add a name for the Ocean cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the OS disk in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @os_disk_size_gb.setter
    def os_disk_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "os_disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the OS disk.
        """
        return pulumi.get(self, "os_disk_type")

    @os_disk_type.setter
    def os_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OS SKU of the OS type. Must correlate with the os type.
        """
        return pulumi.get(self, "os_sku")

    @os_sku.setter
    def os_sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_sku", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OS type of the OS disk. Can't be modified once set.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "pod_subnet_ids")

    @pod_subnet_ids.setter
    def pod_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pod_subnet_ids", value)

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['OceanNpSchedulingArgs']]:
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['OceanNpSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @_builtins.property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Percentage of spot VMs to maintain.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_percentage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpTaintArgs']]]]:
        """
        Add taints to a virtual node group. Only custom user taints are allowed, and not [Kubernetes well-known taints](https://kubernetes.io/docs/reference/labels-annotations-taints/) or Azure AKS [ScaleSetPrioirty (Spot VM) taint](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool). For all Spot VMs, AKS injects a taint kubernetes.azure.com/scalesetpriority=spot:NoSchedule, to ensure that only workloads that can handle interruptions are scheduled on Spot nodes. To [schedule a pod to run on Spot node](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool#schedule-a-pod-to-run-on-the-spot-node), add a toleration but dont include the nodeAffinity (not supported for Spot Ocean), this will prevent the pod from being scheduled using Spot Ocean.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanNpTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanNpUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanNpUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @_builtins.property
    @pulumi.getter(name="vnetSubnetIds")
    def vnet_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "vnet_subnet_ids")

    @vnet_subnet_ids.setter
    def vnet_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vnet_subnet_ids", value)

    @_builtins.property
    @pulumi.getter(name="vngTemplateScheduling")
    def vng_template_scheduling(self) -> Optional[pulumi.Input['OceanNpVngTemplateSchedulingArgs']]:
        """
        An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        return pulumi.get(self, "vng_template_scheduling")

    @vng_template_scheduling.setter
    def vng_template_scheduling(self, value: Optional[pulumi.Input['OceanNpVngTemplateSchedulingArgs']]):
        pulumi.set(self, "vng_template_scheduling", value)


@pulumi.type_token("spotinst:azure/oceanNp:OceanNp")
class OceanNp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aks_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_region: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 autoscaler: Optional[pulumi.Input[Union['OceanNpAutoscalerArgs', 'OceanNpAutoscalerArgsDict']]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Union['OceanNpFiltersArgs', 'OceanNpFiltersArgsDict']]] = None,
                 headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpHeadroomArgs', 'OceanNpHeadroomArgsDict']]]]] = None,
                 health: Optional[pulumi.Input[Union['OceanNpHealthArgs', 'OceanNpHealthArgsDict']]] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpLinuxOsConfigArgs', 'OceanNpLinuxOsConfigArgsDict']]]]] = None,
                 logging: Optional[pulumi.Input[Union['OceanNpLoggingArgs', 'OceanNpLoggingArgsDict']]] = None,
                 max_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 min_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scheduling: Optional[pulumi.Input[Union['OceanNpSchedulingArgs', 'OceanNpSchedulingArgsDict']]] = None,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpTaintArgs', 'OceanNpTaintArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanNpUpdatePolicyArgs', 'OceanNpUpdatePolicyArgsDict']]] = None,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vng_template_scheduling: Optional[pulumi.Input[Union['OceanNpVngTemplateSchedulingArgs', 'OceanNpVngTemplateSchedulingArgsDict']]] = None,
                 __props__=None):
        """
        Create a OceanNp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OceanNpAutoscalerArgs', 'OceanNpAutoscalerArgsDict']] autoscaler: The Ocean Kubernetes Autoscaler object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        :param pulumi.Input[_builtins.str] controller_cluster_id: Enter a unique Ocean cluster identifier. Cannot be updated. This needs to match with string that was used to install the controller in the cluster, typically clusterName + 8 digit string.
        :param pulumi.Input[_builtins.bool] enable_node_public_ip: Enable node public IP.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: If no spot VM markets are available, enable Ocean to launch regular (pay-as-you-go) nodes instead.
        :param pulumi.Input[Union['OceanNpFiltersArgs', 'OceanNpFiltersArgsDict']] filters: Filters for the VM sizes that can be launched from the virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpHeadroomArgs', 'OceanNpHeadroomArgsDict']]]] headrooms: Specify the custom headroom per VNG. Provide a list of headroom objects.
        :param pulumi.Input[Union['OceanNpHealthArgs', 'OceanNpHealthArgsDict']] health: The Ocean AKS Health object.
        :param pulumi.Input[_builtins.str] kubernetes_version: The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: An array of labels to add to the virtual node group. Only custom user labels are allowed, and not [Kubernetes well-known labels](https://kubernetes.io/docs/reference/labels-annotations-taints/) or [ Azure AKS labels](https://learn.microsoft.com/en-us/azure/aks/use-labels) or [Spot labels](https://docs.spot.io/ocean/features/labels-and-taints?id=spot-labels).
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpLinuxOsConfigArgs', 'OceanNpLinuxOsConfigArgsDict']]]] linux_os_configs: Custom Linux OS configuration.
        :param pulumi.Input[Union['OceanNpLoggingArgs', 'OceanNpLoggingArgsDict']] logging: The Ocean AKS Logging Object.
        :param pulumi.Input[_builtins.int] max_count: Maximum node count limit.
        :param pulumi.Input[_builtins.int] max_pods_per_node: The maximum number of pods per node in the node pools.
        :param pulumi.Input[_builtins.int] min_count: Minimum node count limit.
        :param pulumi.Input[_builtins.str] name: Add a name for the Ocean cluster.
        :param pulumi.Input[_builtins.int] os_disk_size_gb: The size of the OS disk in GB.
        :param pulumi.Input[_builtins.str] os_disk_type: The type of the OS disk.
        :param pulumi.Input[_builtins.str] os_sku: The OS SKU of the OS type. Must correlate with the os type.
        :param pulumi.Input[_builtins.str] os_type: The OS type of the OS disk. Can't be modified once set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_subnet_ids: The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        :param pulumi.Input[_builtins.int] spot_percentage: Percentage of spot VMs to maintain.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpTaintArgs', 'OceanNpTaintArgsDict']]]] taints: Add taints to a virtual node group. Only custom user taints are allowed, and not [Kubernetes well-known taints](https://kubernetes.io/docs/reference/labels-annotations-taints/) or Azure AKS [ScaleSetPrioirty (Spot VM) taint](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool). For all Spot VMs, AKS injects a taint kubernetes.azure.com/scalesetpriority=spot:NoSchedule, to ensure that only workloads that can handle interruptions are scheduled on Spot nodes. To [schedule a pod to run on Spot node](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool#schedule-a-pod-to-run-on-the-spot-node), add a toleration but dont include the nodeAffinity (not supported for Spot Ocean), this will prevent the pod from being scheduled using Spot Ocean.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vnet_subnet_ids: The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        :param pulumi.Input[Union['OceanNpVngTemplateSchedulingArgs', 'OceanNpVngTemplateSchedulingArgsDict']] vng_template_scheduling: An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OceanNpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a OceanNp resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param OceanNpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OceanNpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aks_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_region: Optional[pulumi.Input[_builtins.str]] = None,
                 aks_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 autoscaler: Optional[pulumi.Input[Union['OceanNpAutoscalerArgs', 'OceanNpAutoscalerArgsDict']]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_node_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Union['OceanNpFiltersArgs', 'OceanNpFiltersArgsDict']]] = None,
                 headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpHeadroomArgs', 'OceanNpHeadroomArgsDict']]]]] = None,
                 health: Optional[pulumi.Input[Union['OceanNpHealthArgs', 'OceanNpHealthArgsDict']]] = None,
                 kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpLinuxOsConfigArgs', 'OceanNpLinuxOsConfigArgsDict']]]]] = None,
                 logging: Optional[pulumi.Input[Union['OceanNpLoggingArgs', 'OceanNpLoggingArgsDict']]] = None,
                 max_count: Optional[pulumi.Input[_builtins.int]] = None,
                 max_pods_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 min_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 os_sku: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 scheduling: Optional[pulumi.Input[Union['OceanNpSchedulingArgs', 'OceanNpSchedulingArgsDict']]] = None,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpTaintArgs', 'OceanNpTaintArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanNpUpdatePolicyArgs', 'OceanNpUpdatePolicyArgsDict']]] = None,
                 vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 vng_template_scheduling: Optional[pulumi.Input[Union['OceanNpVngTemplateSchedulingArgs', 'OceanNpVngTemplateSchedulingArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OceanNpArgs.__new__(OceanNpArgs)

            if aks_cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'aks_cluster_name'")
            __props__.__dict__["aks_cluster_name"] = aks_cluster_name
            if aks_infrastructure_resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'aks_infrastructure_resource_group_name'")
            __props__.__dict__["aks_infrastructure_resource_group_name"] = aks_infrastructure_resource_group_name
            if aks_region is None and not opts.urn:
                raise TypeError("Missing required property 'aks_region'")
            __props__.__dict__["aks_region"] = aks_region
            if aks_resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'aks_resource_group_name'")
            __props__.__dict__["aks_resource_group_name"] = aks_resource_group_name
            __props__.__dict__["autoscaler"] = autoscaler
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            if controller_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'controller_cluster_id'")
            __props__.__dict__["controller_cluster_id"] = controller_cluster_id
            __props__.__dict__["enable_node_public_ip"] = enable_node_public_ip
            __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
            __props__.__dict__["filters"] = filters
            __props__.__dict__["headrooms"] = headrooms
            __props__.__dict__["health"] = health
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linux_os_configs"] = linux_os_configs
            __props__.__dict__["logging"] = logging
            __props__.__dict__["max_count"] = max_count
            __props__.__dict__["max_pods_per_node"] = max_pods_per_node
            __props__.__dict__["min_count"] = min_count
            __props__.__dict__["name"] = name
            __props__.__dict__["os_disk_size_gb"] = os_disk_size_gb
            __props__.__dict__["os_disk_type"] = os_disk_type
            __props__.__dict__["os_sku"] = os_sku
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["pod_subnet_ids"] = pod_subnet_ids
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["spot_percentage"] = spot_percentage
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["update_policy"] = update_policy
            __props__.__dict__["vnet_subnet_ids"] = vnet_subnet_ids
            __props__.__dict__["vng_template_scheduling"] = vng_template_scheduling
        super(OceanNp, __self__).__init__(
            'spotinst:azure/oceanNp:OceanNp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aks_cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            aks_infrastructure_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            aks_region: Optional[pulumi.Input[_builtins.str]] = None,
            aks_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            autoscaler: Optional[pulumi.Input[Union['OceanNpAutoscalerArgs', 'OceanNpAutoscalerArgsDict']]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_node_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
            filters: Optional[pulumi.Input[Union['OceanNpFiltersArgs', 'OceanNpFiltersArgsDict']]] = None,
            headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpHeadroomArgs', 'OceanNpHeadroomArgsDict']]]]] = None,
            health: Optional[pulumi.Input[Union['OceanNpHealthArgs', 'OceanNpHealthArgsDict']]] = None,
            kubernetes_version: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            linux_os_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpLinuxOsConfigArgs', 'OceanNpLinuxOsConfigArgsDict']]]]] = None,
            logging: Optional[pulumi.Input[Union['OceanNpLoggingArgs', 'OceanNpLoggingArgsDict']]] = None,
            max_count: Optional[pulumi.Input[_builtins.int]] = None,
            max_pods_per_node: Optional[pulumi.Input[_builtins.int]] = None,
            min_count: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            os_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            os_sku: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            pod_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            scheduling: Optional[pulumi.Input[Union['OceanNpSchedulingArgs', 'OceanNpSchedulingArgsDict']]] = None,
            spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanNpTaintArgs', 'OceanNpTaintArgsDict']]]]] = None,
            update_policy: Optional[pulumi.Input[Union['OceanNpUpdatePolicyArgs', 'OceanNpUpdatePolicyArgsDict']]] = None,
            vnet_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            vng_template_scheduling: Optional[pulumi.Input[Union['OceanNpVngTemplateSchedulingArgs', 'OceanNpVngTemplateSchedulingArgsDict']]] = None) -> 'OceanNp':
        """
        Get an existing OceanNp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['OceanNpAutoscalerArgs', 'OceanNpAutoscalerArgsDict']] autoscaler: The Ocean Kubernetes Autoscaler object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        :param pulumi.Input[_builtins.str] controller_cluster_id: Enter a unique Ocean cluster identifier. Cannot be updated. This needs to match with string that was used to install the controller in the cluster, typically clusterName + 8 digit string.
        :param pulumi.Input[_builtins.bool] enable_node_public_ip: Enable node public IP.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: If no spot VM markets are available, enable Ocean to launch regular (pay-as-you-go) nodes instead.
        :param pulumi.Input[Union['OceanNpFiltersArgs', 'OceanNpFiltersArgsDict']] filters: Filters for the VM sizes that can be launched from the virtual node group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpHeadroomArgs', 'OceanNpHeadroomArgsDict']]]] headrooms: Specify the custom headroom per VNG. Provide a list of headroom objects.
        :param pulumi.Input[Union['OceanNpHealthArgs', 'OceanNpHealthArgsDict']] health: The Ocean AKS Health object.
        :param pulumi.Input[_builtins.str] kubernetes_version: The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: An array of labels to add to the virtual node group. Only custom user labels are allowed, and not [Kubernetes well-known labels](https://kubernetes.io/docs/reference/labels-annotations-taints/) or [ Azure AKS labels](https://learn.microsoft.com/en-us/azure/aks/use-labels) or [Spot labels](https://docs.spot.io/ocean/features/labels-and-taints?id=spot-labels).
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpLinuxOsConfigArgs', 'OceanNpLinuxOsConfigArgsDict']]]] linux_os_configs: Custom Linux OS configuration.
        :param pulumi.Input[Union['OceanNpLoggingArgs', 'OceanNpLoggingArgsDict']] logging: The Ocean AKS Logging Object.
        :param pulumi.Input[_builtins.int] max_count: Maximum node count limit.
        :param pulumi.Input[_builtins.int] max_pods_per_node: The maximum number of pods per node in the node pools.
        :param pulumi.Input[_builtins.int] min_count: Minimum node count limit.
        :param pulumi.Input[_builtins.str] name: Add a name for the Ocean cluster.
        :param pulumi.Input[_builtins.int] os_disk_size_gb: The size of the OS disk in GB.
        :param pulumi.Input[_builtins.str] os_disk_type: The type of the OS disk.
        :param pulumi.Input[_builtins.str] os_sku: The OS SKU of the OS type. Must correlate with the os type.
        :param pulumi.Input[_builtins.str] os_type: The OS type of the OS disk. Can't be modified once set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_subnet_ids: The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        :param pulumi.Input[_builtins.int] spot_percentage: Percentage of spot VMs to maintain.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanNpTaintArgs', 'OceanNpTaintArgsDict']]]] taints: Add taints to a virtual node group. Only custom user taints are allowed, and not [Kubernetes well-known taints](https://kubernetes.io/docs/reference/labels-annotations-taints/) or Azure AKS [ScaleSetPrioirty (Spot VM) taint](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool). For all Spot VMs, AKS injects a taint kubernetes.azure.com/scalesetpriority=spot:NoSchedule, to ensure that only workloads that can handle interruptions are scheduled on Spot nodes. To [schedule a pod to run on Spot node](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool#schedule-a-pod-to-run-on-the-spot-node), add a toleration but dont include the nodeAffinity (not supported for Spot Ocean), this will prevent the pod from being scheduled using Spot Ocean.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vnet_subnet_ids: The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        :param pulumi.Input[Union['OceanNpVngTemplateSchedulingArgs', 'OceanNpVngTemplateSchedulingArgsDict']] vng_template_scheduling: An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OceanNpState.__new__(_OceanNpState)

        __props__.__dict__["aks_cluster_name"] = aks_cluster_name
        __props__.__dict__["aks_infrastructure_resource_group_name"] = aks_infrastructure_resource_group_name
        __props__.__dict__["aks_region"] = aks_region
        __props__.__dict__["aks_resource_group_name"] = aks_resource_group_name
        __props__.__dict__["autoscaler"] = autoscaler
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["controller_cluster_id"] = controller_cluster_id
        __props__.__dict__["enable_node_public_ip"] = enable_node_public_ip
        __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__.__dict__["filters"] = filters
        __props__.__dict__["headrooms"] = headrooms
        __props__.__dict__["health"] = health
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["labels"] = labels
        __props__.__dict__["linux_os_configs"] = linux_os_configs
        __props__.__dict__["logging"] = logging
        __props__.__dict__["max_count"] = max_count
        __props__.__dict__["max_pods_per_node"] = max_pods_per_node
        __props__.__dict__["min_count"] = min_count
        __props__.__dict__["name"] = name
        __props__.__dict__["os_disk_size_gb"] = os_disk_size_gb
        __props__.__dict__["os_disk_type"] = os_disk_type
        __props__.__dict__["os_sku"] = os_sku
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["pod_subnet_ids"] = pod_subnet_ids
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["spot_percentage"] = spot_percentage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["vnet_subnet_ids"] = vnet_subnet_ids
        __props__.__dict__["vng_template_scheduling"] = vng_template_scheduling
        return OceanNp(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aksClusterName")
    def aks_cluster_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "aks_cluster_name")

    @_builtins.property
    @pulumi.getter(name="aksInfrastructureResourceGroupName")
    def aks_infrastructure_resource_group_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "aks_infrastructure_resource_group_name")

    @_builtins.property
    @pulumi.getter(name="aksRegion")
    def aks_region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "aks_region")

    @_builtins.property
    @pulumi.getter(name="aksResourceGroupName")
    def aks_resource_group_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "aks_resource_group_name")

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> pulumi.Output[Optional['outputs.OceanNpAutoscaler']]:
        """
        The Ocean Kubernetes Autoscaler object.
        """
        return pulumi.get(self, "autoscaler")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An Array holding Availability Zones, this configures the availability zones the Ocean may launch instances in per VNG.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="controllerClusterId")
    def controller_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Enter a unique Ocean cluster identifier. Cannot be updated. This needs to match with string that was used to install the controller in the cluster, typically clusterName + 8 digit string.
        """
        return pulumi.get(self, "controller_cluster_id")

    @_builtins.property
    @pulumi.getter(name="enableNodePublicIp")
    def enable_node_public_ip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable node public IP.
        """
        return pulumi.get(self, "enable_node_public_ip")

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If no spot VM markets are available, enable Ocean to launch regular (pay-as-you-go) nodes instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.OceanNpFilters']]:
        """
        Filters for the VM sizes that can be launched from the virtual node group.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def headrooms(self) -> pulumi.Output[Optional[Sequence['outputs.OceanNpHeadroom']]]:
        """
        Specify the custom headroom per VNG. Provide a list of headroom objects.
        """
        return pulumi.get(self, "headrooms")

    @_builtins.property
    @pulumi.getter
    def health(self) -> pulumi.Output[Optional['outputs.OceanNpHealth']]:
        """
        The Ocean AKS Health object.
        """
        return pulumi.get(self, "health")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired Kubernetes version of the launched nodes. In case the value is null, the Kubernetes version of the control plane is used.
        """
        return pulumi.get(self, "kubernetes_version")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        An array of labels to add to the virtual node group. Only custom user labels are allowed, and not [Kubernetes well-known labels](https://kubernetes.io/docs/reference/labels-annotations-taints/) or [ Azure AKS labels](https://learn.microsoft.com/en-us/azure/aks/use-labels) or [Spot labels](https://docs.spot.io/ocean/features/labels-and-taints?id=spot-labels).
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="linuxOsConfigs")
    def linux_os_configs(self) -> pulumi.Output[Optional[Sequence['outputs.OceanNpLinuxOsConfig']]]:
        """
        Custom Linux OS configuration.
        """
        return pulumi.get(self, "linux_os_configs")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.OceanNpLogging']]:
        """
        The Ocean AKS Logging Object.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="maxCount")
    def max_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum node count limit.
        """
        return pulumi.get(self, "max_count")

    @_builtins.property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of pods per node in the node pools.
        """
        return pulumi.get(self, "max_pods_per_node")

    @_builtins.property
    @pulumi.getter(name="minCount")
    def min_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Minimum node count limit.
        """
        return pulumi.get(self, "min_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Add a name for the Ocean cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osDiskSizeGb")
    def os_disk_size_gb(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The size of the OS disk in GB.
        """
        return pulumi.get(self, "os_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="osDiskType")
    def os_disk_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the OS disk.
        """
        return pulumi.get(self, "os_disk_type")

    @_builtins.property
    @pulumi.getter(name="osSku")
    def os_sku(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OS SKU of the OS type. Must correlate with the os type.
        """
        return pulumi.get(self, "os_sku")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The OS type of the OS disk. Can't be modified once set.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The IDs of subnets in an existing VNet into which to assign pods in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "pod_subnet_ids")

    @_builtins.property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output[Optional['outputs.OceanNpScheduling']]:
        return pulumi.get(self, "scheduling")

    @_builtins.property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Percentage of spot VMs to maintain.
        """
        return pulumi.get(self, "spot_percentage")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.OceanNpTaint']]]:
        """
        Add taints to a virtual node group. Only custom user taints are allowed, and not [Kubernetes well-known taints](https://kubernetes.io/docs/reference/labels-annotations-taints/) or Azure AKS [ScaleSetPrioirty (Spot VM) taint](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool). For all Spot VMs, AKS injects a taint kubernetes.azure.com/scalesetpriority=spot:NoSchedule, to ensure that only workloads that can handle interruptions are scheduled on Spot nodes. To [schedule a pod to run on Spot node](https://learn.microsoft.com/en-us/azure/aks/spot-node-pool#schedule-a-pod-to-run-on-the-spot-node), add a toleration but dont include the nodeAffinity (not supported for Spot Ocean), this will prevent the pod from being scheduled using Spot Ocean.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[Optional['outputs.OceanNpUpdatePolicy']]:
        return pulumi.get(self, "update_policy")

    @_builtins.property
    @pulumi.getter(name="vnetSubnetIds")
    def vnet_subnet_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The IDs of subnets in an existing VNet into which to assign nodes in the cluster (requires azure network-plugin).
        """
        return pulumi.get(self, "vnet_subnet_ids")

    @_builtins.property
    @pulumi.getter(name="vngTemplateScheduling")
    def vng_template_scheduling(self) -> pulumi.Output[Optional['outputs.OceanNpVngTemplateScheduling']]:
        """
        An object used to specify times when the virtual node group will turn off all its node pools. Once the shutdown time will be over, the virtual node group will return to its previous state.
        """
        return pulumi.get(self, "vng_template_scheduling")

