# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ElastigroupBackendService',
    'ElastigroupBackendServiceBackendBalancing',
    'ElastigroupBackendServiceNamedPort',
    'ElastigroupDisk',
    'ElastigroupDiskInitializeParam',
    'ElastigroupGpu',
    'ElastigroupInstanceTypesCustom',
    'ElastigroupIntegrationDockerSwarm',
    'ElastigroupIntegrationGke',
    'ElastigroupIntegrationGkeAutoscaleDown',
    'ElastigroupIntegrationGkeAutoscaleHeadroom',
    'ElastigroupIntegrationGkeAutoscaleLabel',
    'ElastigroupLabel',
    'ElastigroupMetadata',
    'ElastigroupNetworkInterface',
    'ElastigroupNetworkInterfaceAccessConfig',
    'ElastigroupNetworkInterfaceAliasIpRange',
    'ElastigroupRevertToPreemptible',
    'ElastigroupScalingDownPolicy',
    'ElastigroupScalingDownPolicyDimension',
    'ElastigroupScalingUpPolicy',
    'ElastigroupScalingUpPolicyDimension',
    'ElastigroupScheduledTask',
    'ElastigroupShieldedInstanceConfig',
    'ElastigroupSubnet',
]

@pulumi.output_type
class ElastigroupBackendService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"
        elif key == "backendBalancing":
            suggest = "backend_balancing"
        elif key == "locationType":
            suggest = "location_type"
        elif key == "namedPorts":
            suggest = "named_ports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupBackendService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupBackendService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupBackendService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_name: _builtins.str,
                 backend_balancing: Optional['outputs.ElastigroupBackendServiceBackendBalancing'] = None,
                 location_type: Optional[_builtins.str] = None,
                 named_ports: Optional[Sequence['outputs.ElastigroupBackendServiceNamedPort']] = None,
                 scheme: Optional[_builtins.str] = None):
        """
        :param _builtins.str service_name: The name of the backend service.
        :param 'ElastigroupBackendServiceBackendBalancingArgs' backend_balancing: Configure how traffic is distributed across instance groups.
        :param _builtins.str location_type: Sets which location the backend services will be active. Valid values: `regional`, `global`.
        :param Sequence['ElastigroupBackendServiceNamedPortArgs'] named_ports: Describes a named port and a list of ports.
        :param _builtins.str scheme: Use when `location_type` is "regional". Set the traffic for the backend service to either between the instances in the vpc or to traffic from the internet. Valid values: `INTERNAL`, `EXTERNAL`.
        """
        pulumi.set(__self__, "service_name", service_name)
        if backend_balancing is not None:
            pulumi.set(__self__, "backend_balancing", backend_balancing)
        if location_type is not None:
            pulumi.set(__self__, "location_type", location_type)
        if named_ports is not None:
            pulumi.set(__self__, "named_ports", named_ports)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the backend service.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="backendBalancing")
    def backend_balancing(self) -> Optional['outputs.ElastigroupBackendServiceBackendBalancing']:
        """
        Configure how traffic is distributed across instance groups.
        """
        return pulumi.get(self, "backend_balancing")

    @_builtins.property
    @pulumi.getter(name="locationType")
    def location_type(self) -> Optional[_builtins.str]:
        """
        Sets which location the backend services will be active. Valid values: `regional`, `global`.
        """
        return pulumi.get(self, "location_type")

    @_builtins.property
    @pulumi.getter(name="namedPorts")
    def named_ports(self) -> Optional[Sequence['outputs.ElastigroupBackendServiceNamedPort']]:
        """
        Describes a named port and a list of ports.
        """
        return pulumi.get(self, "named_ports")

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[_builtins.str]:
        """
        Use when `location_type` is "regional". Set the traffic for the backend service to either between the instances in the vpc or to traffic from the internet. Valid values: `INTERNAL`, `EXTERNAL`.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class ElastigroupBackendServiceBackendBalancing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendBalancingMode":
            suggest = "backend_balancing_mode"
        elif key == "maxRatePerInstance":
            suggest = "max_rate_per_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupBackendServiceBackendBalancing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupBackendServiceBackendBalancing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupBackendServiceBackendBalancing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_balancing_mode: Optional[_builtins.str] = None,
                 max_rate_per_instance: Optional[_builtins.int] = None):
        """
        :param _builtins.str backend_balancing_mode: The backend balancing mode. Valid values: `RATE`, `UTILIZATION`.
        :param _builtins.int max_rate_per_instance: If the backendBalancingMode is set to RATE, this field is required.
               
               Usage:
        """
        if backend_balancing_mode is not None:
            pulumi.set(__self__, "backend_balancing_mode", backend_balancing_mode)
        if max_rate_per_instance is not None:
            pulumi.set(__self__, "max_rate_per_instance", max_rate_per_instance)

    @_builtins.property
    @pulumi.getter(name="backendBalancingMode")
    def backend_balancing_mode(self) -> Optional[_builtins.str]:
        """
        The backend balancing mode. Valid values: `RATE`, `UTILIZATION`.
        """
        return pulumi.get(self, "backend_balancing_mode")

    @_builtins.property
    @pulumi.getter(name="maxRatePerInstance")
    def max_rate_per_instance(self) -> Optional[_builtins.int]:
        """
        If the backendBalancingMode is set to RATE, this field is required.

        Usage:
        """
        return pulumi.get(self, "max_rate_per_instance")


@pulumi.output_type
class ElastigroupBackendServiceNamedPort(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 ports: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of the port.
        :param Sequence[_builtins.str] ports: A list of ports.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the port.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Sequence[_builtins.str]:
        """
        A list of ports.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ElastigroupDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDelete":
            suggest = "auto_delete"
        elif key == "deviceName":
            suggest = "device_name"
        elif key == "initializeParams":
            suggest = "initialize_params"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete: Optional[_builtins.bool] = None,
                 boot: Optional[_builtins.bool] = None,
                 device_name: Optional[_builtins.str] = None,
                 initialize_params: Optional[Sequence['outputs.ElastigroupDiskInitializeParam']] = None,
                 interface: Optional[_builtins.str] = None,
                 mode: Optional[_builtins.str] = None,
                 source: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool auto_delete: Specifies whether the disk will be auto-deleted when the instance is deleted.
        :param _builtins.bool boot: Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        :param _builtins.str device_name: Specifies a unique device name of your choice.
        :param Sequence['ElastigroupDiskInitializeParamArgs'] initialize_params: Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
        :param _builtins.str interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        :param _builtins.str mode: The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
        :param _builtins.str source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param _builtins.str type: Specifies the type of disk, either SCRATCH or PERSISTENT.
        """
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if initialize_params is not None:
            pulumi.set(__self__, "initialize_params", initialize_params)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted.
        """
        return pulumi.get(self, "auto_delete")

    @_builtins.property
    @pulumi.getter
    def boot(self) -> Optional[_builtins.bool]:
        """
        Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        return pulumi.get(self, "boot")

    @_builtins.property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[_builtins.str]:
        """
        Specifies a unique device name of your choice.
        """
        return pulumi.get(self, "device_name")

    @_builtins.property
    @pulumi.getter(name="initializeParams")
    def initialize_params(self) -> Optional[Sequence['outputs.ElastigroupDiskInitializeParam']]:
        """
        Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
        """
        return pulumi.get(self, "initialize_params")

    @_builtins.property
    @pulumi.getter
    def interface(self) -> Optional[_builtins.str]:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        """
        return pulumi.get(self, "interface")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Specifies the type of disk, either SCRATCH or PERSISTENT.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ElastigroupDiskInitializeParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceImage":
            suggest = "source_image"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupDiskInitializeParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupDiskInitializeParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupDiskInitializeParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_image: _builtins.str,
                 disk_size_gb: Optional[_builtins.str] = None,
                 disk_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str source_image: A source image used to create the disk. You can provide a private (custom) image, and Compute Engine will use the corresponding image from your project.
               
               Usage:
        :param _builtins.str disk_size_gb: Specifies disk size in gigabytes. Must be in increments of 2.
        :param _builtins.str disk_type: Specifies the disk type to use to create the instance. Valid values: pd-ssd, local-ssd.
        """
        pulumi.set(__self__, "source_image", source_image)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> _builtins.str:
        """
        A source image used to create the disk. You can provide a private (custom) image, and Compute Engine will use the corresponding image from your project.

        Usage:
        """
        return pulumi.get(self, "source_image")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.str]:
        """
        Specifies disk size in gigabytes. Must be in increments of 2.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[_builtins.str]:
        """
        Specifies the disk type to use to create the instance. Valid values: pd-ssd, local-ssd.
        """
        return pulumi.get(self, "disk_type")


@pulumi.output_type
class ElastigroupGpu(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.int count: The number of GPUs. Must be 0, 2, 4, 6, 8.
               
               Usage:
        :param _builtins.str type: The type of GPU instance. Valid values: `nvidia-tesla-v100`, `nvidia-tesla-p100`, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        The number of GPUs. Must be 0, 2, 4, 6, 8.

        Usage:
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of GPU instance. Valid values: `nvidia-tesla-v100`, `nvidia-tesla-p100`, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ElastigroupInstanceTypesCustom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryGib":
            suggest = "memory_gib"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupInstanceTypesCustom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupInstanceTypesCustom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupInstanceTypesCustom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_gib: _builtins.int,
                 vcpu: _builtins.int):
        """
        :param _builtins.int memory_gib: The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        pulumi.set(__self__, "memory_gib", memory_gib)
        pulumi.set(__self__, "vcpu", vcpu)

    @_builtins.property
    @pulumi.getter(name="memoryGib")
    def memory_gib(self) -> _builtins.int:
        """
        The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        return pulumi.get(self, "memory_gib")

    @_builtins.property
    @pulumi.getter
    def vcpu(self) -> _builtins.int:
        return pulumi.get(self, "vcpu")


@pulumi.output_type
class ElastigroupIntegrationDockerSwarm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "masterHost":
            suggest = "master_host"
        elif key == "masterPort":
            suggest = "master_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationDockerSwarm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationDockerSwarm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationDockerSwarm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 master_host: _builtins.str,
                 master_port: _builtins.int):
        """
        :param _builtins.str master_host: IP or FQDN of one of your swarm managers.
        :param _builtins.int master_port: Network port used by your swarm.
               
               Usage:
        """
        pulumi.set(__self__, "master_host", master_host)
        pulumi.set(__self__, "master_port", master_port)

    @_builtins.property
    @pulumi.getter(name="masterHost")
    def master_host(self) -> _builtins.str:
        """
        IP or FQDN of one of your swarm managers.
        """
        return pulumi.get(self, "master_host")

    @_builtins.property
    @pulumi.getter(name="masterPort")
    def master_port(self) -> _builtins.int:
        """
        Network port used by your swarm.

        Usage:
        """
        return pulumi.get(self, "master_port")


@pulumi.output_type
class ElastigroupIntegrationGke(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUpdate":
            suggest = "auto_update"
        elif key == "autoscaleCooldown":
            suggest = "autoscale_cooldown"
        elif key == "autoscaleDown":
            suggest = "autoscale_down"
        elif key == "autoscaleHeadroom":
            suggest = "autoscale_headroom"
        elif key == "autoscaleIsAutoConfig":
            suggest = "autoscale_is_auto_config"
        elif key == "autoscaleIsEnabled":
            suggest = "autoscale_is_enabled"
        elif key == "autoscaleLabels":
            suggest = "autoscale_labels"
        elif key == "clusterId":
            suggest = "cluster_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationGke. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationGke.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationGke.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_update: Optional[_builtins.bool] = None,
                 autoscale_cooldown: Optional[_builtins.int] = None,
                 autoscale_down: Optional['outputs.ElastigroupIntegrationGkeAutoscaleDown'] = None,
                 autoscale_headroom: Optional['outputs.ElastigroupIntegrationGkeAutoscaleHeadroom'] = None,
                 autoscale_is_auto_config: Optional[_builtins.bool] = None,
                 autoscale_is_enabled: Optional[_builtins.bool] = None,
                 autoscale_labels: Optional[Sequence['outputs.ElastigroupIntegrationGkeAutoscaleLabel']] = None,
                 cluster_id: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None):
        if auto_update is not None:
            pulumi.set(__self__, "auto_update", auto_update)
        if autoscale_cooldown is not None:
            pulumi.set(__self__, "autoscale_cooldown", autoscale_cooldown)
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_auto_config is not None:
            pulumi.set(__self__, "autoscale_is_auto_config", autoscale_is_auto_config)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)
        if autoscale_labels is not None:
            pulumi.set(__self__, "autoscale_labels", autoscale_labels)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @_builtins.property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "auto_update")

    @_builtins.property
    @pulumi.getter(name="autoscaleCooldown")
    def autoscale_cooldown(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "autoscale_cooldown")

    @_builtins.property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional['outputs.ElastigroupIntegrationGkeAutoscaleDown']:
        return pulumi.get(self, "autoscale_down")

    @_builtins.property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional['outputs.ElastigroupIntegrationGkeAutoscaleHeadroom']:
        return pulumi.get(self, "autoscale_headroom")

    @_builtins.property
    @pulumi.getter(name="autoscaleIsAutoConfig")
    def autoscale_is_auto_config(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "autoscale_is_auto_config")

    @_builtins.property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "autoscale_is_enabled")

    @_builtins.property
    @pulumi.getter(name="autoscaleLabels")
    def autoscale_labels(self) -> Optional[Sequence['outputs.ElastigroupIntegrationGkeAutoscaleLabel']]:
        return pulumi.get(self, "autoscale_labels")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "location")


@pulumi.output_type
class ElastigroupIntegrationGkeAutoscaleDown(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationPeriods":
            suggest = "evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationGkeAutoscaleDown. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationGkeAutoscaleDown.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationGkeAutoscaleDown.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_periods: Optional[_builtins.int] = None):
        """
        :param _builtins.int evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)

    @_builtins.property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[_builtins.int]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")


@pulumi.output_type
class ElastigroupIntegrationGkeAutoscaleHeadroom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuPerUnit":
            suggest = "cpu_per_unit"
        elif key == "memoryPerUnit":
            suggest = "memory_per_unit"
        elif key == "numOfUnits":
            suggest = "num_of_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupIntegrationGkeAutoscaleHeadroom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupIntegrationGkeAutoscaleHeadroom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupIntegrationGkeAutoscaleHeadroom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_per_unit: Optional[_builtins.int] = None,
                 memory_per_unit: Optional[_builtins.int] = None,
                 num_of_units: Optional[_builtins.int] = None):
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @_builtins.property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "cpu_per_unit")

    @_builtins.property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "memory_per_unit")

    @_builtins.property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "num_of_units")


@pulumi.output_type
class ElastigroupIntegrationGkeAutoscaleLabel(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupLabel(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Labels key.
        :param _builtins.str value: Labels value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Labels key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Labels value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupMetadata(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Metadata key.
        :param _builtins.str value: Metadata value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Metadata key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Metadata value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfigs":
            suggest = "access_configs"
        elif key == "aliasIpRanges":
            suggest = "alias_ip_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: _builtins.str,
                 access_configs: Optional[Sequence['outputs.ElastigroupNetworkInterfaceAccessConfig']] = None,
                 alias_ip_ranges: Optional[Sequence['outputs.ElastigroupNetworkInterfaceAliasIpRange']] = None):
        """
        :param _builtins.str network: Network resource for this group.
        :param Sequence['ElastigroupNetworkInterfaceAccessConfigArgs'] access_configs: Array of configurations.
        """
        pulumi.set(__self__, "network", network)
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if alias_ip_ranges is not None:
            pulumi.set(__self__, "alias_ip_ranges", alias_ip_ranges)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Network resource for this group.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[Sequence['outputs.ElastigroupNetworkInterfaceAccessConfig']]:
        """
        Array of configurations.
        """
        return pulumi.get(self, "access_configs")

    @_builtins.property
    @pulumi.getter(name="aliasIpRanges")
    def alias_ip_ranges(self) -> Optional[Sequence['outputs.ElastigroupNetworkInterfaceAliasIpRange']]:
        return pulumi.get(self, "alias_ip_ranges")


@pulumi.output_type
class ElastigroupNetworkInterfaceAccessConfig(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The group name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class ElastigroupNetworkInterfaceAliasIpRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipCidrRange":
            suggest = "ip_cidr_range"
        elif key == "subnetworkRangeName":
            suggest = "subnetwork_range_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupNetworkInterfaceAliasIpRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupNetworkInterfaceAliasIpRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupNetworkInterfaceAliasIpRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_cidr_range: _builtins.str,
                 subnetwork_range_name: _builtins.str):
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        pulumi.set(__self__, "subnetwork_range_name", subnetwork_range_name)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> _builtins.str:
        return pulumi.get(self, "ip_cidr_range")

    @_builtins.property
    @pulumi.getter(name="subnetworkRangeName")
    def subnetwork_range_name(self) -> _builtins.str:
        return pulumi.get(self, "subnetwork_range_name")


@pulumi.output_type
class ElastigroupRevertToPreemptible(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performAt":
            suggest = "perform_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupRevertToPreemptible. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupRevertToPreemptible.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupRevertToPreemptible.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 perform_at: _builtins.str):
        """
        :param _builtins.str perform_at: Valid values: "always", "never", "timeWindow". Required on strategy.revertToPreemptible object.
        """
        pulumi.set(__self__, "perform_at", perform_at)

    @_builtins.property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> _builtins.str:
        """
        Valid values: "always", "never", "timeWindow". Required on strategy.revertToPreemptible object.
        """
        return pulumi.get(self, "perform_at")


@pulumi.output_type
class ElastigroupScalingDownPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingDownPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingDownPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingDownPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: _builtins.str,
                 namespace: _builtins.str,
                 policy_name: _builtins.str,
                 threshold: _builtins.float,
                 unit: _builtins.str,
                 action_type: Optional[_builtins.str] = None,
                 adjustment: Optional[_builtins.int] = None,
                 cooldown: Optional[_builtins.int] = None,
                 dimensions: Optional[Sequence['outputs.ElastigroupScalingDownPolicyDimension']] = None,
                 evaluation_periods: Optional[_builtins.int] = None,
                 operator: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 source: Optional[_builtins.str] = None,
                 statistic: Optional[_builtins.str] = None):
        """
        :param _builtins.str metric_name: Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        :param _builtins.str policy_name: Name of scaling policy.
        :param _builtins.float threshold: The value at which the scaling action is triggered.
        :param _builtins.str action_type: Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        :param _builtins.int adjustment: Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        :param _builtins.int cooldown: Time (seconds) to wait after a scaling action before resuming monitoring.
        :param Sequence['ElastigroupScalingDownPolicyDimensionArgs'] dimensions: A list of dimensions describing qualities of the metric.
        :param _builtins.int evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        :param _builtins.str operator: The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        :param _builtins.int period: Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        :param _builtins.str source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param _builtins.str statistic: Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> _builtins.str:
        """
        Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> _builtins.str:
        """
        Name of scaling policy.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        The value at which the scaling action is triggered.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[_builtins.str]:
        """
        Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        """
        return pulumi.get(self, "action_type")

    @_builtins.property
    @pulumi.getter
    def adjustment(self) -> Optional[_builtins.int]:
        """
        Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        """
        return pulumi.get(self, "adjustment")

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> Optional[_builtins.int]:
        """
        Time (seconds) to wait after a scaling action before resuming monitoring.
        """
        return pulumi.get(self, "cooldown")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ElastigroupScalingDownPolicyDimension']]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[_builtins.int]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def statistic(self) -> Optional[_builtins.str]:
        """
        Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        return pulumi.get(self, "statistic")


@pulumi.output_type
class ElastigroupScalingDownPolicyDimension(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The group name.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupScalingUpPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"
        elif key == "policyName":
            suggest = "policy_name"
        elif key == "actionType":
            suggest = "action_type"
        elif key == "evaluationPeriods":
            suggest = "evaluation_periods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScalingUpPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScalingUpPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScalingUpPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: _builtins.str,
                 namespace: _builtins.str,
                 policy_name: _builtins.str,
                 threshold: _builtins.float,
                 unit: _builtins.str,
                 action_type: Optional[_builtins.str] = None,
                 adjustment: Optional[_builtins.int] = None,
                 cooldown: Optional[_builtins.int] = None,
                 dimensions: Optional[Sequence['outputs.ElastigroupScalingUpPolicyDimension']] = None,
                 evaluation_periods: Optional[_builtins.int] = None,
                 operator: Optional[_builtins.str] = None,
                 period: Optional[_builtins.int] = None,
                 source: Optional[_builtins.str] = None,
                 statistic: Optional[_builtins.str] = None):
        """
        :param _builtins.str metric_name: Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        :param _builtins.str policy_name: Name of scaling policy.
        :param _builtins.float threshold: The value at which the scaling action is triggered.
        :param _builtins.str action_type: Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        :param _builtins.int adjustment: Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        :param _builtins.int cooldown: Time (seconds) to wait after a scaling action before resuming monitoring.
        :param Sequence['ElastigroupScalingUpPolicyDimensionArgs'] dimensions: A list of dimensions describing qualities of the metric.
        :param _builtins.int evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        :param _builtins.str operator: The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        :param _builtins.int period: Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        :param _builtins.str source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param _builtins.str statistic: Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> _builtins.str:
        """
        Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> _builtins.str:
        """
        Name of scaling policy.
        """
        return pulumi.get(self, "policy_name")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        The value at which the scaling action is triggered.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def unit(self) -> _builtins.str:
        return pulumi.get(self, "unit")

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[_builtins.str]:
        """
        Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        """
        return pulumi.get(self, "action_type")

    @_builtins.property
    @pulumi.getter
    def adjustment(self) -> Optional[_builtins.int]:
        """
        Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        """
        return pulumi.get(self, "adjustment")

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> Optional[_builtins.int]:
        """
        Time (seconds) to wait after a scaling action before resuming monitoring.
        """
        return pulumi.get(self, "cooldown")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ElastigroupScalingUpPolicyDimension']]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[_builtins.int]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def statistic(self) -> Optional[_builtins.str]:
        """
        Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        return pulumi.get(self, "statistic")


@pulumi.output_type
class ElastigroupScalingUpPolicyDimension(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The dimension name.
        :param _builtins.str value: The dimension value.
               
               Usage:
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The dimension name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The dimension value.

        Usage:
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ElastigroupScheduledTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskType":
            suggest = "task_type"
        elif key == "cronExpression":
            suggest = "cron_expression"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "targetCapacity":
            suggest = "target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupScheduledTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupScheduledTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupScheduledTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_type: _builtins.str,
                 cron_expression: Optional[_builtins.str] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 max_capacity: Optional[_builtins.str] = None,
                 min_capacity: Optional[_builtins.str] = None,
                 target_capacity: Optional[_builtins.str] = None):
        """
        :param _builtins.str task_type: The task type to run. Valid values: `"setCapacity"`.
        :param _builtins.str cron_expression: A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        :param _builtins.bool is_enabled: Setting the task to being enabled or disabled.
        :param _builtins.str max_capacity: The maximum number of instances the group should have.
               
               Usage:
        :param _builtins.str min_capacity: The minimum number of instances the group should have.
        :param _builtins.str target_capacity: The desired number of instances the group should have.
        """
        pulumi.set(__self__, "task_type", task_type)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> _builtins.str:
        """
        The task type to run. Valid values: `"setCapacity"`.
        """
        return pulumi.get(self, "task_type")

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[_builtins.str]:
        """
        A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        """
        return pulumi.get(self, "cron_expression")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Setting the task to being enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[_builtins.str]:
        """
        The maximum number of instances the group should have.

        Usage:
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[_builtins.str]:
        """
        The minimum number of instances the group should have.
        """
        return pulumi.get(self, "min_capacity")

    @_builtins.property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[_builtins.str]:
        """
        The desired number of instances the group should have.
        """
        return pulumi.get(self, "target_capacity")


@pulumi.output_type
class ElastigroupShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[_builtins.bool] = None,
                 enable_secure_boot: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_integrity_monitoring: Default: false
        :param _builtins.bool enable_secure_boot: Default: false
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @_builtins.property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[_builtins.bool]:
        """
        Default: false
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @_builtins.property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[_builtins.bool]:
        """
        Default: false
        """
        return pulumi.get(self, "enable_secure_boot")


@pulumi.output_type
class ElastigroupSubnet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetNames":
            suggest = "subnet_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElastigroupSubnet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElastigroupSubnet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElastigroupSubnet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: _builtins.str,
                 subnet_names: Sequence[_builtins.str]):
        """
        :param _builtins.str region: The region for the group of subnets.
        :param Sequence[_builtins.str] subnet_names: The names of the subnets in the region.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet_names", subnet_names)

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region for the group of subnets.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="subnetNames")
    def subnet_names(self) -> Sequence[_builtins.str]:
        """
        The names of the subnets in the region.
        """
        return pulumi.get(self, "subnet_names")


