# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OceanLaunchSpecArgs', 'OceanLaunchSpec']

@pulumi.input_type
class OceanLaunchSpecArgs:
    def __init__(__self__, *,
                 ocean_id: pulumi.Input[_builtins.str],
                 autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]] = None,
                 autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]] = None,
                 create_options: Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']] = None,
                 filters: Optional[pulumi.Input['OceanLaunchSpecFiltersArgs']] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecNetworkInterfaceArgs']]]] = None,
                 node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_limits: Optional[pulumi.Input['OceanLaunchSpecResourceLimitsArgs']] = None,
                 restrict_scale_down: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['OceanLaunchSpecShieldedInstanceConfigArgs']] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input['OceanLaunchSpecStorageArgs']] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']] = None):
        """
        The set of arguments for constructing a OceanLaunchSpec resource.
        :param pulumi.Input[_builtins.str] ocean_id: The Ocean cluster ID.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]] autoscale_headrooms: Set custom headroom per launch spec. provide list of headrooms object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]] autoscale_headrooms_automatics: Set automatic headroom per launch spec.
        :param pulumi.Input['OceanLaunchSpecFiltersArgs'] filters: List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured if cluster's `instance_types` is configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: List of supported machine types for the Launch Spec.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]] labels: Optionally adds labels to instances launched in an Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecMetadataArgs']]] metadatas: Cluster's metadata.
        :param pulumi.Input[_builtins.str] name: The launch specification name.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecNetworkInterfaceArgs']]] network_interfaces: Settings for network interfaces.
        :param pulumi.Input[_builtins.str] node_pool_name: The node pool you wish to use in your Launch Spec.
        :param pulumi.Input['OceanLaunchSpecResourceLimitsArgs'] resource_limits: The Ocean virtual node group resource limits object.
        :param pulumi.Input[_builtins.bool] restrict_scale_down: Boolean. When set to `true`, VNG nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        :param pulumi.Input[_builtins.int] root_volume_size: Root volume size (in GB).
        :param pulumi.Input[_builtins.str] root_volume_type: Root volume disk type. Valid values: `"pd-standard"`, `"pd-ssd"`.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]] scheduling_tasks: Used to define scheduled tasks such as a manual headroom update.
        :param pulumi.Input[_builtins.str] service_account: The account used by applications running on the VM to call GCP APIs.
        :param pulumi.Input['OceanLaunchSpecShieldedInstanceConfigArgs'] shielded_instance_config: The Ocean shielded instance configuration object.
        :param pulumi.Input[_builtins.str] source_image: Image URL.
        :param pulumi.Input['OceanLaunchSpecStorageArgs'] storage: The Ocean virtual node group storage object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]] strategies: The Ocean Launch Spec Strategy object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Every node launched from this configuration will be tagged with those tags. Note: during creation some tags are automatically imported to the state file, it is required to manually add it to the template configuration
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]] taints: Optionally adds labels to instances launched in an Ocean cluster.
        """
        pulumi.set(__self__, "ocean_id", ocean_id)
        if autoscale_headrooms is not None:
            pulumi.set(__self__, "autoscale_headrooms", autoscale_headrooms)
        if autoscale_headrooms_automatics is not None:
            pulumi.set(__self__, "autoscale_headrooms_automatics", autoscale_headrooms_automatics)
        if create_options is not None:
            pulumi.set(__self__, "create_options", create_options)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if node_pool_name is not None:
            pulumi.set(__self__, "node_pool_name", node_pool_name)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)
        if restrict_scale_down is not None:
            pulumi.set(__self__, "restrict_scale_down", restrict_scale_down)
        if root_volume_size is not None:
            pulumi.set(__self__, "root_volume_size", root_volume_size)
        if root_volume_type is not None:
            pulumi.set(__self__, "root_volume_type", root_volume_type)
        if scheduling_tasks is not None:
            pulumi.set(__self__, "scheduling_tasks", scheduling_tasks)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if strategies is not None:
            pulumi.set(__self__, "strategies", strategies)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)

    @_builtins.property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Ocean cluster ID.
        """
        return pulumi.get(self, "ocean_id")

    @ocean_id.setter
    def ocean_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ocean_id", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleHeadrooms")
    def autoscale_headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]]:
        """
        Set custom headroom per launch spec. provide list of headrooms object.
        """
        return pulumi.get(self, "autoscale_headrooms")

    @autoscale_headrooms.setter
    def autoscale_headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]]):
        pulumi.set(self, "autoscale_headrooms", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleHeadroomsAutomatics")
    def autoscale_headrooms_automatics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]]:
        """
        Set automatic headroom per launch spec.
        """
        return pulumi.get(self, "autoscale_headrooms_automatics")

    @autoscale_headrooms_automatics.setter
    def autoscale_headrooms_automatics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]]):
        pulumi.set(self, "autoscale_headrooms_automatics", value)

    @_builtins.property
    @pulumi.getter(name="createOptions")
    def create_options(self) -> Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']]:
        return pulumi.get(self, "create_options")

    @create_options.setter
    def create_options(self, value: Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']]):
        pulumi.set(self, "create_options", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanLaunchSpecFiltersArgs']]:
        """
        List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured if cluster's `instance_types` is configured.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanLaunchSpecFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported machine types for the Launch Spec.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]]:
        """
        Optionally adds labels to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecMetadataArgs']]]]:
        """
        Cluster's metadata.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The launch specification name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecNetworkInterfaceArgs']]]]:
        """
        Settings for network interfaces.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The node pool you wish to use in your Launch Spec.
        """
        return pulumi.get(self, "node_pool_name")

    @node_pool_name.setter
    def node_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional[pulumi.Input['OceanLaunchSpecResourceLimitsArgs']]:
        """
        The Ocean virtual node group resource limits object.
        """
        return pulumi.get(self, "resource_limits")

    @resource_limits.setter
    def resource_limits(self, value: Optional[pulumi.Input['OceanLaunchSpecResourceLimitsArgs']]):
        pulumi.set(self, "resource_limits", value)

    @_builtins.property
    @pulumi.getter(name="restrictScaleDown")
    def restrict_scale_down(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean. When set to `true`, VNG nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        """
        return pulumi.get(self, "restrict_scale_down")

    @restrict_scale_down.setter
    def restrict_scale_down(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restrict_scale_down", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Root volume size (in GB).
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Root volume disk type. Valid values: `"pd-standard"`, `"pd-ssd"`.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="schedulingTasks")
    def scheduling_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]]:
        """
        Used to define scheduled tasks such as a manual headroom update.
        """
        return pulumi.get(self, "scheduling_tasks")

    @scheduling_tasks.setter
    def scheduling_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]]):
        pulumi.set(self, "scheduling_tasks", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account used by applications running on the VM to call GCP APIs.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['OceanLaunchSpecShieldedInstanceConfigArgs']]:
        """
        The Ocean shielded instance configuration object.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['OceanLaunchSpecShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image URL.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['OceanLaunchSpecStorageArgs']]:
        """
        The Ocean virtual node group storage object.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['OceanLaunchSpecStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]]:
        """
        The Ocean Launch Spec Strategy object.
        """
        return pulumi.get(self, "strategies")

    @strategies.setter
    def strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]]):
        pulumi.set(self, "strategies", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Every node launched from this configuration will be tagged with those tags. Note: during creation some tags are automatically imported to the state file, it is required to manually add it to the template configuration
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]]:
        """
        Optionally adds labels to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)


@pulumi.input_type
class _OceanLaunchSpecState:
    def __init__(__self__, *,
                 autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]] = None,
                 autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]] = None,
                 create_options: Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']] = None,
                 filters: Optional[pulumi.Input['OceanLaunchSpecFiltersArgs']] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecMetadataArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecNetworkInterfaceArgs']]]] = None,
                 node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ocean_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_limits: Optional[pulumi.Input['OceanLaunchSpecResourceLimitsArgs']] = None,
                 restrict_scale_down: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['OceanLaunchSpecShieldedInstanceConfigArgs']] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input['OceanLaunchSpecStorageArgs']] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']] = None):
        """
        Input properties used for looking up and filtering OceanLaunchSpec resources.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]] autoscale_headrooms: Set custom headroom per launch spec. provide list of headrooms object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]] autoscale_headrooms_automatics: Set automatic headroom per launch spec.
        :param pulumi.Input['OceanLaunchSpecFiltersArgs'] filters: List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured if cluster's `instance_types` is configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: List of supported machine types for the Launch Spec.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]] labels: Optionally adds labels to instances launched in an Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecMetadataArgs']]] metadatas: Cluster's metadata.
        :param pulumi.Input[_builtins.str] name: The launch specification name.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecNetworkInterfaceArgs']]] network_interfaces: Settings for network interfaces.
        :param pulumi.Input[_builtins.str] node_pool_name: The node pool you wish to use in your Launch Spec.
        :param pulumi.Input[_builtins.str] ocean_id: The Ocean cluster ID.
        :param pulumi.Input['OceanLaunchSpecResourceLimitsArgs'] resource_limits: The Ocean virtual node group resource limits object.
        :param pulumi.Input[_builtins.bool] restrict_scale_down: Boolean. When set to `true`, VNG nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        :param pulumi.Input[_builtins.int] root_volume_size: Root volume size (in GB).
        :param pulumi.Input[_builtins.str] root_volume_type: Root volume disk type. Valid values: `"pd-standard"`, `"pd-ssd"`.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]] scheduling_tasks: Used to define scheduled tasks such as a manual headroom update.
        :param pulumi.Input[_builtins.str] service_account: The account used by applications running on the VM to call GCP APIs.
        :param pulumi.Input['OceanLaunchSpecShieldedInstanceConfigArgs'] shielded_instance_config: The Ocean shielded instance configuration object.
        :param pulumi.Input[_builtins.str] source_image: Image URL.
        :param pulumi.Input['OceanLaunchSpecStorageArgs'] storage: The Ocean virtual node group storage object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]] strategies: The Ocean Launch Spec Strategy object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Every node launched from this configuration will be tagged with those tags. Note: during creation some tags are automatically imported to the state file, it is required to manually add it to the template configuration
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]] taints: Optionally adds labels to instances launched in an Ocean cluster.
        """
        if autoscale_headrooms is not None:
            pulumi.set(__self__, "autoscale_headrooms", autoscale_headrooms)
        if autoscale_headrooms_automatics is not None:
            pulumi.set(__self__, "autoscale_headrooms_automatics", autoscale_headrooms_automatics)
        if create_options is not None:
            pulumi.set(__self__, "create_options", create_options)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if node_pool_name is not None:
            pulumi.set(__self__, "node_pool_name", node_pool_name)
        if ocean_id is not None:
            pulumi.set(__self__, "ocean_id", ocean_id)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)
        if restrict_scale_down is not None:
            pulumi.set(__self__, "restrict_scale_down", restrict_scale_down)
        if root_volume_size is not None:
            pulumi.set(__self__, "root_volume_size", root_volume_size)
        if root_volume_type is not None:
            pulumi.set(__self__, "root_volume_type", root_volume_type)
        if scheduling_tasks is not None:
            pulumi.set(__self__, "scheduling_tasks", scheduling_tasks)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if strategies is not None:
            pulumi.set(__self__, "strategies", strategies)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)

    @_builtins.property
    @pulumi.getter(name="autoscaleHeadrooms")
    def autoscale_headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]]:
        """
        Set custom headroom per launch spec. provide list of headrooms object.
        """
        return pulumi.get(self, "autoscale_headrooms")

    @autoscale_headrooms.setter
    def autoscale_headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomArgs']]]]):
        pulumi.set(self, "autoscale_headrooms", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleHeadroomsAutomatics")
    def autoscale_headrooms_automatics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]]:
        """
        Set automatic headroom per launch spec.
        """
        return pulumi.get(self, "autoscale_headrooms_automatics")

    @autoscale_headrooms_automatics.setter
    def autoscale_headrooms_automatics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs']]]]):
        pulumi.set(self, "autoscale_headrooms_automatics", value)

    @_builtins.property
    @pulumi.getter(name="createOptions")
    def create_options(self) -> Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']]:
        return pulumi.get(self, "create_options")

    @create_options.setter
    def create_options(self, value: Optional[pulumi.Input['OceanLaunchSpecCreateOptionsArgs']]):
        pulumi.set(self, "create_options", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanLaunchSpecFiltersArgs']]:
        """
        List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured if cluster's `instance_types` is configured.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanLaunchSpecFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported machine types for the Launch Spec.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]]:
        """
        Optionally adds labels to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecMetadataArgs']]]]:
        """
        Cluster's metadata.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The launch specification name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecNetworkInterfaceArgs']]]]:
        """
        Settings for network interfaces.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The node pool you wish to use in your Launch Spec.
        """
        return pulumi.get(self, "node_pool_name")

    @node_pool_name.setter
    def node_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Ocean cluster ID.
        """
        return pulumi.get(self, "ocean_id")

    @ocean_id.setter
    def ocean_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ocean_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional[pulumi.Input['OceanLaunchSpecResourceLimitsArgs']]:
        """
        The Ocean virtual node group resource limits object.
        """
        return pulumi.get(self, "resource_limits")

    @resource_limits.setter
    def resource_limits(self, value: Optional[pulumi.Input['OceanLaunchSpecResourceLimitsArgs']]):
        pulumi.set(self, "resource_limits", value)

    @_builtins.property
    @pulumi.getter(name="restrictScaleDown")
    def restrict_scale_down(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean. When set to `true`, VNG nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        """
        return pulumi.get(self, "restrict_scale_down")

    @restrict_scale_down.setter
    def restrict_scale_down(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restrict_scale_down", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Root volume size (in GB).
        """
        return pulumi.get(self, "root_volume_size")

    @root_volume_size.setter
    def root_volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "root_volume_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Root volume disk type. Valid values: `"pd-standard"`, `"pd-ssd"`.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="schedulingTasks")
    def scheduling_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]]:
        """
        Used to define scheduled tasks such as a manual headroom update.
        """
        return pulumi.get(self, "scheduling_tasks")

    @scheduling_tasks.setter
    def scheduling_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskArgs']]]]):
        pulumi.set(self, "scheduling_tasks", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account used by applications running on the VM to call GCP APIs.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['OceanLaunchSpecShieldedInstanceConfigArgs']]:
        """
        The Ocean shielded instance configuration object.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['OceanLaunchSpecShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Image URL.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['OceanLaunchSpecStorageArgs']]:
        """
        The Ocean virtual node group storage object.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['OceanLaunchSpecStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]]:
        """
        The Ocean Launch Spec Strategy object.
        """
        return pulumi.get(self, "strategies")

    @strategies.setter
    def strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecStrategyArgs']]]]):
        pulumi.set(self, "strategies", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Every node launched from this configuration will be tagged with those tags. Note: during creation some tags are automatically imported to the state file, it is required to manually add it to the template configuration
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]]:
        """
        Optionally adds labels to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanLaunchSpecUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)


@pulumi.type_token("spotinst:gke/oceanLaunchSpec:OceanLaunchSpec")
class OceanLaunchSpec(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]]] = None,
                 autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]]] = None,
                 create_options: Optional[pulumi.Input[Union['OceanLaunchSpecCreateOptionsArgs', 'OceanLaunchSpecCreateOptionsArgsDict']]] = None,
                 filters: Optional[pulumi.Input[Union['OceanLaunchSpecFiltersArgs', 'OceanLaunchSpecFiltersArgsDict']]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecMetadataArgs', 'OceanLaunchSpecMetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecNetworkInterfaceArgs', 'OceanLaunchSpecNetworkInterfaceArgsDict']]]]] = None,
                 node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ocean_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_limits: Optional[pulumi.Input[Union['OceanLaunchSpecResourceLimitsArgs', 'OceanLaunchSpecResourceLimitsArgsDict']]] = None,
                 restrict_scale_down: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['OceanLaunchSpecShieldedInstanceConfigArgs', 'OceanLaunchSpecShieldedInstanceConfigArgsDict']]] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input[Union['OceanLaunchSpecStorageArgs', 'OceanLaunchSpecStorageArgsDict']]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStrategyArgs', 'OceanLaunchSpecStrategyArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanLaunchSpecUpdatePolicyArgs', 'OceanLaunchSpecUpdatePolicyArgsDict']]] = None,
                 __props__=None):
        """
        Manages a custom Spotinst Ocean GKE Launch Spec resource.

        > This resource can be imported from GKE node pool or not. If you want to import the node pool and create the VNG from it, please provide `node_pool_name`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.gke.OceanLaunchSpec("example",
            ocean_id="o-123456",
            node_pool_name="default-pool",
            name="specialty.nodes.spotk8s.com",
            source_image="image",
            restrict_scale_down=True,
            root_volume_size=10,
            root_volume_type="pd-standard",
            instance_types=["n1-standard-1, n1-standard-2"],
            tags=[
                "tag1",
                "tag2",
            ],
            create_options={
                "initial_nodes": 1,
            },
            shielded_instance_config={
                "enable_secure_boot": False,
                "enable_integrity_monitoring": True,
            },
            storage={
                "local_ssd_count": 5,
            },
            resource_limits={
                "max_instance_count": 3,
                "min_instance_count": 0,
            },
            service_account="default",
            metadatas=[{
                "key": "gci-update-strategy",
                "value": "update_disabled",
            }],
            labels=[{
                "key": "labelKey",
                "value": "labelVal",
            }],
            taints=[{
                "key": "taintKey",
                "value": "taintVal",
                "effect": "taintEffect",
            }],
            autoscale_headrooms_automatics=[{
                "auto_headroom_percentage": 5,
            }],
            autoscale_headrooms=[{
                "num_of_units": 5,
                "cpu_per_unit": 1000,
                "gpu_per_unit": 0,
                "memory_per_unit": 2048,
            }],
            strategies=[{
                "preemptible_percentage": 30,
                "scaling_orientation": "balanced",
            }],
            scheduling_tasks=[{
                "is_enabled": True,
                "cron_expression": "0 1 * * *",
                "task_type": "manualHeadroomUpdate",
                "task_headrooms": [{
                    "num_of_units": 5,
                    "cpu_per_unit": 1000,
                    "gpu_per_unit": 0,
                    "memory_per_unit": 2048,
                }],
            }],
            network_interfaces=[{
                "network": "test-vng-network",
                "project_id": "test-vng-network-project",
                "access_configs": [{
                    "name": "external-nat-vng",
                    "type": "ONE_TO_ONE_NAT",
                }],
                "alias_ip_ranges": [{
                    "ip_cidr_range": "/25",
                    "subnetwork_range_name": "gke-test-native-vpc-pods-123456-vng",
                }],
            }],
            filters={
                "exclude_families": ["n2"],
                "include_families": [
                    "c2",
                    "c3",
                ],
                "min_memory_gib": 8,
                "max_memory_gib": 32,
                "min_vcpu": 2,
                "max_vcpu": 16,
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]] autoscale_headrooms: Set custom headroom per launch spec. provide list of headrooms object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]] autoscale_headrooms_automatics: Set automatic headroom per launch spec.
        :param pulumi.Input[Union['OceanLaunchSpecFiltersArgs', 'OceanLaunchSpecFiltersArgsDict']] filters: List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured if cluster's `instance_types` is configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: List of supported machine types for the Launch Spec.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]] labels: Optionally adds labels to instances launched in an Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecMetadataArgs', 'OceanLaunchSpecMetadataArgsDict']]]] metadatas: Cluster's metadata.
        :param pulumi.Input[_builtins.str] name: The launch specification name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecNetworkInterfaceArgs', 'OceanLaunchSpecNetworkInterfaceArgsDict']]]] network_interfaces: Settings for network interfaces.
        :param pulumi.Input[_builtins.str] node_pool_name: The node pool you wish to use in your Launch Spec.
        :param pulumi.Input[_builtins.str] ocean_id: The Ocean cluster ID.
        :param pulumi.Input[Union['OceanLaunchSpecResourceLimitsArgs', 'OceanLaunchSpecResourceLimitsArgsDict']] resource_limits: The Ocean virtual node group resource limits object.
        :param pulumi.Input[_builtins.bool] restrict_scale_down: Boolean. When set to `true`, VNG nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        :param pulumi.Input[_builtins.int] root_volume_size: Root volume size (in GB).
        :param pulumi.Input[_builtins.str] root_volume_type: Root volume disk type. Valid values: `"pd-standard"`, `"pd-ssd"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]] scheduling_tasks: Used to define scheduled tasks such as a manual headroom update.
        :param pulumi.Input[_builtins.str] service_account: The account used by applications running on the VM to call GCP APIs.
        :param pulumi.Input[Union['OceanLaunchSpecShieldedInstanceConfigArgs', 'OceanLaunchSpecShieldedInstanceConfigArgsDict']] shielded_instance_config: The Ocean shielded instance configuration object.
        :param pulumi.Input[_builtins.str] source_image: Image URL.
        :param pulumi.Input[Union['OceanLaunchSpecStorageArgs', 'OceanLaunchSpecStorageArgsDict']] storage: The Ocean virtual node group storage object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStrategyArgs', 'OceanLaunchSpecStrategyArgsDict']]]] strategies: The Ocean Launch Spec Strategy object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Every node launched from this configuration will be tagged with those tags. Note: during creation some tags are automatically imported to the state file, it is required to manually add it to the template configuration
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]] taints: Optionally adds labels to instances launched in an Ocean cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OceanLaunchSpecArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a custom Spotinst Ocean GKE Launch Spec resource.

        > This resource can be imported from GKE node pool or not. If you want to import the node pool and create the VNG from it, please provide `node_pool_name`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.gke.OceanLaunchSpec("example",
            ocean_id="o-123456",
            node_pool_name="default-pool",
            name="specialty.nodes.spotk8s.com",
            source_image="image",
            restrict_scale_down=True,
            root_volume_size=10,
            root_volume_type="pd-standard",
            instance_types=["n1-standard-1, n1-standard-2"],
            tags=[
                "tag1",
                "tag2",
            ],
            create_options={
                "initial_nodes": 1,
            },
            shielded_instance_config={
                "enable_secure_boot": False,
                "enable_integrity_monitoring": True,
            },
            storage={
                "local_ssd_count": 5,
            },
            resource_limits={
                "max_instance_count": 3,
                "min_instance_count": 0,
            },
            service_account="default",
            metadatas=[{
                "key": "gci-update-strategy",
                "value": "update_disabled",
            }],
            labels=[{
                "key": "labelKey",
                "value": "labelVal",
            }],
            taints=[{
                "key": "taintKey",
                "value": "taintVal",
                "effect": "taintEffect",
            }],
            autoscale_headrooms_automatics=[{
                "auto_headroom_percentage": 5,
            }],
            autoscale_headrooms=[{
                "num_of_units": 5,
                "cpu_per_unit": 1000,
                "gpu_per_unit": 0,
                "memory_per_unit": 2048,
            }],
            strategies=[{
                "preemptible_percentage": 30,
                "scaling_orientation": "balanced",
            }],
            scheduling_tasks=[{
                "is_enabled": True,
                "cron_expression": "0 1 * * *",
                "task_type": "manualHeadroomUpdate",
                "task_headrooms": [{
                    "num_of_units": 5,
                    "cpu_per_unit": 1000,
                    "gpu_per_unit": 0,
                    "memory_per_unit": 2048,
                }],
            }],
            network_interfaces=[{
                "network": "test-vng-network",
                "project_id": "test-vng-network-project",
                "access_configs": [{
                    "name": "external-nat-vng",
                    "type": "ONE_TO_ONE_NAT",
                }],
                "alias_ip_ranges": [{
                    "ip_cidr_range": "/25",
                    "subnetwork_range_name": "gke-test-native-vpc-pods-123456-vng",
                }],
            }],
            filters={
                "exclude_families": ["n2"],
                "include_families": [
                    "c2",
                    "c3",
                ],
                "min_memory_gib": 8,
                "max_memory_gib": 32,
                "min_vcpu": 2,
                "max_vcpu": 16,
            })
        ```

        :param str resource_name: The name of the resource.
        :param OceanLaunchSpecArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OceanLaunchSpecArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]]] = None,
                 autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]]] = None,
                 create_options: Optional[pulumi.Input[Union['OceanLaunchSpecCreateOptionsArgs', 'OceanLaunchSpecCreateOptionsArgsDict']]] = None,
                 filters: Optional[pulumi.Input[Union['OceanLaunchSpecFiltersArgs', 'OceanLaunchSpecFiltersArgsDict']]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecMetadataArgs', 'OceanLaunchSpecMetadataArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecNetworkInterfaceArgs', 'OceanLaunchSpecNetworkInterfaceArgsDict']]]]] = None,
                 node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ocean_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_limits: Optional[pulumi.Input[Union['OceanLaunchSpecResourceLimitsArgs', 'OceanLaunchSpecResourceLimitsArgsDict']]] = None,
                 restrict_scale_down: Optional[pulumi.Input[_builtins.bool]] = None,
                 root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['OceanLaunchSpecShieldedInstanceConfigArgs', 'OceanLaunchSpecShieldedInstanceConfigArgsDict']]] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input[Union['OceanLaunchSpecStorageArgs', 'OceanLaunchSpecStorageArgsDict']]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStrategyArgs', 'OceanLaunchSpecStrategyArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanLaunchSpecUpdatePolicyArgs', 'OceanLaunchSpecUpdatePolicyArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OceanLaunchSpecArgs.__new__(OceanLaunchSpecArgs)

            __props__.__dict__["autoscale_headrooms"] = autoscale_headrooms
            __props__.__dict__["autoscale_headrooms_automatics"] = autoscale_headrooms_automatics
            __props__.__dict__["create_options"] = create_options
            __props__.__dict__["filters"] = filters
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["labels"] = labels
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["node_pool_name"] = node_pool_name
            if ocean_id is None and not opts.urn:
                raise TypeError("Missing required property 'ocean_id'")
            __props__.__dict__["ocean_id"] = ocean_id
            __props__.__dict__["resource_limits"] = resource_limits
            __props__.__dict__["restrict_scale_down"] = restrict_scale_down
            __props__.__dict__["root_volume_size"] = root_volume_size
            __props__.__dict__["root_volume_type"] = root_volume_type
            __props__.__dict__["scheduling_tasks"] = scheduling_tasks
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["source_image"] = source_image
            __props__.__dict__["storage"] = storage
            __props__.__dict__["strategies"] = strategies
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["update_policy"] = update_policy
        super(OceanLaunchSpec, __self__).__init__(
            'spotinst:gke/oceanLaunchSpec:OceanLaunchSpec',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscale_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]]] = None,
            autoscale_headrooms_automatics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]]] = None,
            create_options: Optional[pulumi.Input[Union['OceanLaunchSpecCreateOptionsArgs', 'OceanLaunchSpecCreateOptionsArgsDict']]] = None,
            filters: Optional[pulumi.Input[Union['OceanLaunchSpecFiltersArgs', 'OceanLaunchSpecFiltersArgsDict']]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecMetadataArgs', 'OceanLaunchSpecMetadataArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecNetworkInterfaceArgs', 'OceanLaunchSpecNetworkInterfaceArgsDict']]]]] = None,
            node_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            ocean_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_limits: Optional[pulumi.Input[Union['OceanLaunchSpecResourceLimitsArgs', 'OceanLaunchSpecResourceLimitsArgsDict']]] = None,
            restrict_scale_down: Optional[pulumi.Input[_builtins.bool]] = None,
            root_volume_size: Optional[pulumi.Input[_builtins.int]] = None,
            root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
            scheduling_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            shielded_instance_config: Optional[pulumi.Input[Union['OceanLaunchSpecShieldedInstanceConfigArgs', 'OceanLaunchSpecShieldedInstanceConfigArgsDict']]] = None,
            source_image: Optional[pulumi.Input[_builtins.str]] = None,
            storage: Optional[pulumi.Input[Union['OceanLaunchSpecStorageArgs', 'OceanLaunchSpecStorageArgsDict']]] = None,
            strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStrategyArgs', 'OceanLaunchSpecStrategyArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]]] = None,
            update_policy: Optional[pulumi.Input[Union['OceanLaunchSpecUpdatePolicyArgs', 'OceanLaunchSpecUpdatePolicyArgsDict']]] = None) -> 'OceanLaunchSpec':
        """
        Get an existing OceanLaunchSpec resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomArgs', 'OceanLaunchSpecAutoscaleHeadroomArgsDict']]]] autoscale_headrooms: Set custom headroom per launch spec. provide list of headrooms object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecAutoscaleHeadroomsAutomaticArgs', 'OceanLaunchSpecAutoscaleHeadroomsAutomaticArgsDict']]]] autoscale_headrooms_automatics: Set automatic headroom per launch spec.
        :param pulumi.Input[Union['OceanLaunchSpecFiltersArgs', 'OceanLaunchSpecFiltersArgsDict']] filters: List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured if cluster's `instance_types` is configured.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types: List of supported machine types for the Launch Spec.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecLabelArgs', 'OceanLaunchSpecLabelArgsDict']]]] labels: Optionally adds labels to instances launched in an Ocean cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecMetadataArgs', 'OceanLaunchSpecMetadataArgsDict']]]] metadatas: Cluster's metadata.
        :param pulumi.Input[_builtins.str] name: The launch specification name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecNetworkInterfaceArgs', 'OceanLaunchSpecNetworkInterfaceArgsDict']]]] network_interfaces: Settings for network interfaces.
        :param pulumi.Input[_builtins.str] node_pool_name: The node pool you wish to use in your Launch Spec.
        :param pulumi.Input[_builtins.str] ocean_id: The Ocean cluster ID.
        :param pulumi.Input[Union['OceanLaunchSpecResourceLimitsArgs', 'OceanLaunchSpecResourceLimitsArgsDict']] resource_limits: The Ocean virtual node group resource limits object.
        :param pulumi.Input[_builtins.bool] restrict_scale_down: Boolean. When set to `true`, VNG nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        :param pulumi.Input[_builtins.int] root_volume_size: Root volume size (in GB).
        :param pulumi.Input[_builtins.str] root_volume_type: Root volume disk type. Valid values: `"pd-standard"`, `"pd-ssd"`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecSchedulingTaskArgs', 'OceanLaunchSpecSchedulingTaskArgsDict']]]] scheduling_tasks: Used to define scheduled tasks such as a manual headroom update.
        :param pulumi.Input[_builtins.str] service_account: The account used by applications running on the VM to call GCP APIs.
        :param pulumi.Input[Union['OceanLaunchSpecShieldedInstanceConfigArgs', 'OceanLaunchSpecShieldedInstanceConfigArgsDict']] shielded_instance_config: The Ocean shielded instance configuration object.
        :param pulumi.Input[_builtins.str] source_image: Image URL.
        :param pulumi.Input[Union['OceanLaunchSpecStorageArgs', 'OceanLaunchSpecStorageArgsDict']] storage: The Ocean virtual node group storage object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecStrategyArgs', 'OceanLaunchSpecStrategyArgsDict']]]] strategies: The Ocean Launch Spec Strategy object.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Every node launched from this configuration will be tagged with those tags. Note: during creation some tags are automatically imported to the state file, it is required to manually add it to the template configuration
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanLaunchSpecTaintArgs', 'OceanLaunchSpecTaintArgsDict']]]] taints: Optionally adds labels to instances launched in an Ocean cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OceanLaunchSpecState.__new__(_OceanLaunchSpecState)

        __props__.__dict__["autoscale_headrooms"] = autoscale_headrooms
        __props__.__dict__["autoscale_headrooms_automatics"] = autoscale_headrooms_automatics
        __props__.__dict__["create_options"] = create_options
        __props__.__dict__["filters"] = filters
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["labels"] = labels
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["node_pool_name"] = node_pool_name
        __props__.__dict__["ocean_id"] = ocean_id
        __props__.__dict__["resource_limits"] = resource_limits
        __props__.__dict__["restrict_scale_down"] = restrict_scale_down
        __props__.__dict__["root_volume_size"] = root_volume_size
        __props__.__dict__["root_volume_type"] = root_volume_type
        __props__.__dict__["scheduling_tasks"] = scheduling_tasks
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["source_image"] = source_image
        __props__.__dict__["storage"] = storage
        __props__.__dict__["strategies"] = strategies
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["update_policy"] = update_policy
        return OceanLaunchSpec(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoscaleHeadrooms")
    def autoscale_headrooms(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecAutoscaleHeadroom']]]:
        """
        Set custom headroom per launch spec. provide list of headrooms object.
        """
        return pulumi.get(self, "autoscale_headrooms")

    @_builtins.property
    @pulumi.getter(name="autoscaleHeadroomsAutomatics")
    def autoscale_headrooms_automatics(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecAutoscaleHeadroomsAutomatic']]]:
        """
        Set automatic headroom per launch spec.
        """
        return pulumi.get(self, "autoscale_headrooms_automatics")

    @_builtins.property
    @pulumi.getter(name="createOptions")
    def create_options(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecCreateOptions']]:
        return pulumi.get(self, "create_options")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecFilters']]:
        """
        List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured if cluster's `instance_types` is configured.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of supported machine types for the Launch Spec.
        """
        return pulumi.get(self, "instance_types")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Sequence['outputs.OceanLaunchSpecLabel']]:
        """
        Optionally adds labels to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.OceanLaunchSpecMetadata']]:
        """
        Cluster's metadata.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The launch specification name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecNetworkInterface']]]:
        """
        Settings for network interfaces.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="nodePoolName")
    def node_pool_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The node pool you wish to use in your Launch Spec.
        """
        return pulumi.get(self, "node_pool_name")

    @_builtins.property
    @pulumi.getter(name="oceanId")
    def ocean_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Ocean cluster ID.
        """
        return pulumi.get(self, "ocean_id")

    @_builtins.property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecResourceLimits']]:
        """
        The Ocean virtual node group resource limits object.
        """
        return pulumi.get(self, "resource_limits")

    @_builtins.property
    @pulumi.getter(name="restrictScaleDown")
    def restrict_scale_down(self) -> pulumi.Output[_builtins.bool]:
        """
        Boolean. When set to `true`, VNG nodes will be treated as if all pods running have the restrict-scale-down label. Therefore, Ocean will not scale nodes down unless empty.
        """
        return pulumi.get(self, "restrict_scale_down")

    @_builtins.property
    @pulumi.getter(name="rootVolumeSize")
    def root_volume_size(self) -> pulumi.Output[_builtins.int]:
        """
        Root volume size (in GB).
        """
        return pulumi.get(self, "root_volume_size")

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Output[_builtins.str]:
        """
        Root volume disk type. Valid values: `"pd-standard"`, `"pd-ssd"`.
        """
        return pulumi.get(self, "root_volume_type")

    @_builtins.property
    @pulumi.getter(name="schedulingTasks")
    def scheduling_tasks(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecSchedulingTask']]]:
        """
        Used to define scheduled tasks such as a manual headroom update.
        """
        return pulumi.get(self, "scheduling_tasks")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[_builtins.str]:
        """
        The account used by applications running on the VM to call GCP APIs.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.OceanLaunchSpecShieldedInstanceConfig']:
        """
        The Ocean shielded instance configuration object.
        """
        return pulumi.get(self, "shielded_instance_config")

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> pulumi.Output[_builtins.str]:
        """
        Image URL.
        """
        return pulumi.get(self, "source_image")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Output['outputs.OceanLaunchSpecStorage']:
        """
        The Ocean virtual node group storage object.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def strategies(self) -> pulumi.Output[Optional[Sequence['outputs.OceanLaunchSpecStrategy']]]:
        """
        The Ocean Launch Spec Strategy object.
        """
        return pulumi.get(self, "strategies")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Every node launched from this configuration will be tagged with those tags. Note: during creation some tags are automatically imported to the state file, it is required to manually add it to the template configuration
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Sequence['outputs.OceanLaunchSpecTaint']]:
        """
        Optionally adds labels to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[Optional['outputs.OceanLaunchSpecUpdatePolicy']]:
        return pulumi.get(self, "update_policy")

