# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAuthenticationDomainResult',
    'AwaitableGetAuthenticationDomainResult',
    'get_authentication_domain',
    'get_authentication_domain_output',
]

@pulumi.output_type
class GetAuthenticationDomainResult:
    """
    A collection of values returned by getAuthenticationDomain.
    """
    def __init__(__self__, id=None, name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the matching authentication domain fetched.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


class AwaitableGetAuthenticationDomainResult(GetAuthenticationDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthenticationDomainResult(
            id=self.id,
            name=self.name)


def get_authentication_domain(name: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthenticationDomainResult:
    """
    Use this data source to fetch the ID of an authentication domain belonging to your account, matching the specified name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    foo = newrelic.get_authentication_domain(name="Test Authentication Domain")
    pulumi.export("foo", foo.id)
    ```


    :param builtins.str name: The name of the authentication domain to be searched for. An error is thrown, if no authentication domain is found with the specified name.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('newrelic:index/getAuthenticationDomain:getAuthenticationDomain', __args__, opts=opts, typ=GetAuthenticationDomainResult).value

    return AwaitableGetAuthenticationDomainResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_authentication_domain_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthenticationDomainResult]:
    """
    Use this data source to fetch the ID of an authentication domain belonging to your account, matching the specified name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    foo = newrelic.get_authentication_domain(name="Test Authentication Domain")
    pulumi.export("foo", foo.id)
    ```


    :param builtins.str name: The name of the authentication domain to be searched for. An error is thrown, if no authentication domain is found with the specified name.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('newrelic:index/getAuthenticationDomain:getAuthenticationDomain', __args__, opts=opts, typ=GetAuthenticationDomainResult)
    return __ret__.apply(lambda __response__: GetAuthenticationDomainResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
