# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 authentication_domain_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[builtins.str] authentication_domain_id: The ID of the authentication domain to which the group to be created would belong.
        :param pulumi.Input[builtins.str] name: The name of the group to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_ids: A list of IDs of users to be included in the group to be created.
               
               > **NOTE** The ID of an authentication domain can be retrieved using its name, via the data source `get_authentication_domain`, as shown in the example above. Head over to the documentation of this data source for more details and examples.
               
               > **WARNING:** Changing the `authentication_domain_id` of a `Group` resource that has already been applied would result in a **replacement** of the resource – destruction of the existing resource, followed by the addition of a new resource with the specified configuration. This is due to the fact that updating the `authentication_domain_id` of an existing group is not supported.
        """
        pulumi.set(__self__, "authentication_domain_id", authentication_domain_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="authenticationDomainId")
    def authentication_domain_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the authentication domain to which the group to be created would belong.
        """
        return pulumi.get(self, "authentication_domain_id")

    @authentication_domain_id.setter
    def authentication_domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authentication_domain_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the group to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IDs of users to be included in the group to be created.

        > **NOTE** The ID of an authentication domain can be retrieved using its name, via the data source `get_authentication_domain`, as shown in the example above. Head over to the documentation of this data source for more details and examples.

        > **WARNING:** Changing the `authentication_domain_id` of a `Group` resource that has already been applied would result in a **replacement** of the resource – destruction of the existing resource, followed by the addition of a new resource with the specified configuration. This is due to the fact that updating the `authentication_domain_id` of an existing group is not supported.
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 authentication_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[builtins.str] authentication_domain_id: The ID of the authentication domain to which the group to be created would belong.
        :param pulumi.Input[builtins.str] name: The name of the group to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_ids: A list of IDs of users to be included in the group to be created.
               
               > **NOTE** The ID of an authentication domain can be retrieved using its name, via the data source `get_authentication_domain`, as shown in the example above. Head over to the documentation of this data source for more details and examples.
               
               > **WARNING:** Changing the `authentication_domain_id` of a `Group` resource that has already been applied would result in a **replacement** of the resource – destruction of the existing resource, followed by the addition of a new resource with the specified configuration. This is due to the fact that updating the `authentication_domain_id` of an existing group is not supported.
        """
        if authentication_domain_id is not None:
            pulumi.set(__self__, "authentication_domain_id", authentication_domain_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="authenticationDomainId")
    def authentication_domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the authentication domain to which the group to be created would belong.
        """
        return pulumi.get(self, "authentication_domain_id")

    @authentication_domain_id.setter
    def authentication_domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_domain_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the group to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IDs of users to be included in the group to be created.

        > **NOTE** The ID of an authentication domain can be retrieved using its name, via the data source `get_authentication_domain`, as shown in the example above. Head over to the documentation of this data source for more details and examples.

        > **WARNING:** Changing the `authentication_domain_id` of a `Group` resource that has already been applied would result in a **replacement** of the resource – destruction of the existing resource, followed by the addition of a new resource with the specified configuration. This is due to the fact that updating the `authentication_domain_id` of an existing group is not supported.
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.type_token("newrelic:index/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        ## Import

        A group can be imported using its ID. Example:

        ```sh
        $ pulumi import newrelic:index/group:Group foo <group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_domain_id: The ID of the authentication domain to which the group to be created would belong.
        :param pulumi.Input[builtins.str] name: The name of the group to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_ids: A list of IDs of users to be included in the group to be created.
               
               > **NOTE** The ID of an authentication domain can be retrieved using its name, via the data source `get_authentication_domain`, as shown in the example above. Head over to the documentation of this data source for more details and examples.
               
               > **WARNING:** Changing the `authentication_domain_id` of a `Group` resource that has already been applied would result in a **replacement** of the resource – destruction of the existing resource, followed by the addition of a new resource with the specified configuration. This is due to the fact that updating the `authentication_domain_id` of an existing group is not supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        A group can be imported using its ID. Example:

        ```sh
        $ pulumi import newrelic:index/group:Group foo <group_id>
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            if authentication_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_domain_id'")
            __props__.__dict__["authentication_domain_id"] = authentication_domain_id
            __props__.__dict__["name"] = name
            __props__.__dict__["user_ids"] = user_ids
        super(Group, __self__).__init__(
            'newrelic:index/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_domain_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_domain_id: The ID of the authentication domain to which the group to be created would belong.
        :param pulumi.Input[builtins.str] name: The name of the group to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] user_ids: A list of IDs of users to be included in the group to be created.
               
               > **NOTE** The ID of an authentication domain can be retrieved using its name, via the data source `get_authentication_domain`, as shown in the example above. Head over to the documentation of this data source for more details and examples.
               
               > **WARNING:** Changing the `authentication_domain_id` of a `Group` resource that has already been applied would result in a **replacement** of the resource – destruction of the existing resource, followed by the addition of a new resource with the specified configuration. This is due to the fact that updating the `authentication_domain_id` of an existing group is not supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["authentication_domain_id"] = authentication_domain_id
        __props__.__dict__["name"] = name
        __props__.__dict__["user_ids"] = user_ids
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationDomainId")
    def authentication_domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the authentication domain to which the group to be created would belong.
        """
        return pulumi.get(self, "authentication_domain_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the group to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of IDs of users to be included in the group to be created.

        > **NOTE** The ID of an authentication domain can be retrieved using its name, via the data source `get_authentication_domain`, as shown in the example above. Head over to the documentation of this data source for more details and examples.

        > **WARNING:** Changing the `authentication_domain_id` of a `Group` resource that has already been applied would result in a **replacement** of the resource – destruction of the existing resource, followed by the addition of a new resource with the specified configuration. This is due to the fact that updating the `authentication_domain_id` of an existing group is not supported.
        """
        return pulumi.get(self, "user_ids")

