import unittest
from mindsdb.integrations.handlers.pinot_handler.pinot_handler import PinotHandler
from mindsdb.api.executor.data_types.response_type import RESPONSE_TYPE


class PinotHandlerTest(unittest.TestCase):
    @classmethod
    def setUpClass(cls):
        cls.kwargs = {
            "host": "localhost",
            "broker_port": 8000,
            "controller_port": 9000,
            "path": "/query/sql",
            "scheme": "http"
        }
        cls.handler = PinotHandler('test_pinot_handler', cls.kwargs)

    def test_0_check_connection(self):
        assert self.handler.check_connection()

    def test_1_native_query_select(self):
        query = "SELECT * FROM baseballStats"
        result = self.handler.native_query(query)
        assert result.type is RESPONSE_TYPE.TABLE

    def test_2_get_tables(self):
        tables = self.handler.get_tables()
        assert tables.type is not RESPONSE_TYPE.ERROR

    def test_3_get_columns(self):
        columns = self.handler.get_columns('baseballStats')
        assert columns.type is not RESPONSE_TYPE.ERROR


if __name__ == '__main__':
    unittest.main()
