from pygryfsmart.const import OutputActions, DriverFunctions
from pygryfsmart import GryfApi

from .base import _GryfDevice

class GryfOutput(_GryfDevice):
    def __init__(
        self,
        name: str,
        id: int,
        pin: int,
        api: GryfApi,
        update_fun_ptr=None,
    ):
        self._attributes = {
            "id": id,
            "pin": pin,
        }

        super().__init__(name,
                         id,
                         pin,
                         api)
        if update_fun_ptr:
            self._api.subscribe(self._id , self._pin , DriverFunctions.OUTPUTS , update_fun_ptr)

    def subscribe(self , update_fun_ptr):
        self._api.subscribe(self._id , self._pin, DriverFunctions.OUTPUTS , update_fun_ptr)

    @property
    def name(self):
        return f"{self._name}"

    async def turn_on(self):
        await self._api.set_out(self._id, self._pin, OutputActions.ON)

    async def turn_off(self):
        await self._api.set_out(self._id, self._pin, OutputActions.OFF)

    async def toggle(self):
        await self._api.set_out(self._id, self._pin, OutputActions.TOGGLE)
