"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grafana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const dashboard_1 = require("./dashboard");
const datasource_1 = require("./datasource");
const grafana_1 = require("./imports/grafana");
/**
 * A Grafana instance.
 */
class Grafana extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.labels = props.labels ?? { app: 'grafana' };
        this.dataSources = [];
        this.dashboards = [];
        this.namespace = props.namespace;
        const baseImage = props.image ?? 'public.ecr.aws/ubuntu/grafana:latest';
        const ingress = props.ingress ?? true;
        const serviceType = props.serviceType ?? 'ClusterIP';
        const adminUser = props.adminUser ?? 'root';
        const adminPassword = props.adminPassword ?? 'secret';
        const requireLogin = props.requireLogin ?? false;
        const dashboardLabelSelectors = [{ matchLabels: this.labels ?? { app: 'grafana' } }];
        new grafana_1.Grafana(this, 'Resource', {
            metadata: {
                labels: this.labels,
                namespace: this.namespace,
            },
            spec: {
                baseImage: baseImage,
                ingress: {
                    enabled: ingress,
                },
                service: {
                    type: serviceType,
                },
                client: {
                    // without this, dashboards may not be automatically discovered
                    // https://github.com/grafana-operator/grafana-operator/blob/master/documentation/deploy_grafana.md#configuring-grafana-api-access
                    preferService: true,
                },
                config: {
                    'log': {
                        mode: 'console',
                        level: 'info',
                    },
                    'auth.anonymous': {
                        enabled: !requireLogin,
                    },
                    'security': {
                        admin_user: adminUser,
                        admin_password: adminPassword,
                    },
                },
                deployment: {
                    labels: this.labels,
                },
                dashboardLabelSelector: dashboardLabelSelectors,
            },
        });
        if (props.defaultDataSource) {
            this.addDataSource('default-datasource', props.defaultDataSource);
        }
    }
    /**
     * Adds a data source. By default, labels are automatically added so that
     * the data source is detected by Grafana.
     */
    addDataSource(id, props) {
        const labels = {
            ...this.labels,
            ...props.labels,
        };
        const datasource = new datasource_1.DataSource(this, id, {
            labels,
            namespace: this.namespace,
            ...props,
        });
        this.dataSources.push(datasource);
        return datasource;
    }
    /**
     * Creates a dashboard associated with a particular data source. By default,
     * labels are automatically added so that the data source is detected by
     * Grafana.
     */
    addDashboard(id, props) {
        const labels = {
            ...this.labels,
            ...props.labels,
        };
        const dashboard = new dashboard_1.Dashboard(this, id, {
            labels,
            namespace: this.namespace,
            ...props,
        });
        this.dashboards.push(dashboard);
        return dashboard;
    }
}
exports.Grafana = Grafana;
_a = JSII_RTTI_SYMBOL_1;
Grafana[_a] = { fqn: "cdk8s-grafana.Grafana", version: "0.1.726" };
//# sourceMappingURL=data:application/json;base64,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