# KLL Compiler - emitters

The KLL compiler uses an emitter to handle the output format of the parsed input KLL file data.
The output can be in whatever format(s) that may required.


## Emitters

Description of each of the KLL emitters.


### [kiibohd](kiibohd)

The main emitter for the KLL compiler, it is used for the [Kiibohd Controller firmware](https://github.com/kiibohd/controller).
It currently generates 3-4 different files.

* `generatedKeymap.h` - Handles layers, scancode to USB code mapping and mapping to capabilities.
* `generatedPixelmap.h` - (PixelMap only) Handles LED channel mapping to pixels and animations.
* `kll_defs.h` - Various defines exported by the KLL compiler and used by the firmware.
* `kll.json` - JSON expansion of datastructures generated by the KLL compiler. Used by testing and other infrastructure around the firmware.


### [kll](kll)

This emitter generates a set of kll files using the input data.
Used by the [regen](../tests/regen.bash) unit test to determine whether the KLL compiler properly tokenized and parsed a given kll file.
Can also be used to manually combine a selection of kll files into one per layer.


### [none](none)

This emitter...generates nothing!
Generally used for syntax checking and debugging.


## Files

Brief description of each of the files.

* [emitters.py](emitters.py) - Handles each of the emitter modules. Must be updated to include new emitters.

