# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.identity import Identity
from ..types.identity_property import IdentityProperty
from ..types.identity_type import IdentityType
from .properties.client import AsyncPropertiesClient, PropertiesClient
from .raw_client import AsyncRawIdentitiesClient, RawIdentitiesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class IdentitiesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIdentitiesClient(client_wrapper=client_wrapper)
        self.properties = PropertiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawIdentitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIdentitiesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        name: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        identifier_key: typing.Optional[str] = None,
        identity_type: typing.Optional[IdentityType] = None,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Identity]:
        """
        Get a list of all identities in the database

        Parameters
        ----------
        name : typing.Optional[str]

        project_id : typing.Optional[str]

        identifier_key : typing.Optional[str]

        identity_type : typing.Optional[IdentityType]

        before : typing.Optional[str]

        after : typing.Optional[str]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Identity]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.identities.list()
        """
        _response = self._raw_client.list(
            name=name,
            project_id=project_id,
            identifier_key=identifier_key,
            identity_type=identity_type,
            before=before,
            after=after,
            limit=limit,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        identifier_key: str,
        name: str,
        identity_type: IdentityType,
        project_id: typing.Optional[str] = OMIT,
        agent_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        block_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        properties: typing.Optional[typing.Sequence[IdentityProperty]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Identity:
        """
        Parameters
        ----------
        identifier_key : str
            External, user-generated identifier key of the identity.

        name : str
            The name of the identity.

        identity_type : IdentityType
            The type of the identity.

        project_id : typing.Optional[str]
            The project id of the identity, if applicable.

        agent_ids : typing.Optional[typing.Sequence[str]]
            The agent ids that are associated with the identity.

        block_ids : typing.Optional[typing.Sequence[str]]
            The IDs of the blocks associated with the identity.

        properties : typing.Optional[typing.Sequence[IdentityProperty]]
            List of properties associated with the identity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Identity
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.identities.create(
            identifier_key="identifier_key",
            name="name",
            identity_type="org",
        )
        """
        _response = self._raw_client.create(
            identifier_key=identifier_key,
            name=name,
            identity_type=identity_type,
            project_id=project_id,
            agent_ids=agent_ids,
            block_ids=block_ids,
            properties=properties,
            request_options=request_options,
        )
        return _response.data

    def upsert(
        self,
        *,
        identifier_key: str,
        name: str,
        identity_type: IdentityType,
        project_id: typing.Optional[str] = OMIT,
        agent_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        block_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        properties: typing.Optional[typing.Sequence[IdentityProperty]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Identity:
        """
        Parameters
        ----------
        identifier_key : str
            External, user-generated identifier key of the identity.

        name : str
            The name of the identity.

        identity_type : IdentityType
            The type of the identity.

        project_id : typing.Optional[str]
            The project id of the identity, if applicable.

        agent_ids : typing.Optional[typing.Sequence[str]]
            The agent ids that are associated with the identity.

        block_ids : typing.Optional[typing.Sequence[str]]
            The IDs of the blocks associated with the identity.

        properties : typing.Optional[typing.Sequence[IdentityProperty]]
            List of properties associated with the identity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Identity
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.identities.upsert(
            identifier_key="identifier_key",
            name="name",
            identity_type="org",
        )
        """
        _response = self._raw_client.upsert(
            identifier_key=identifier_key,
            name=name,
            identity_type=identity_type,
            project_id=project_id,
            agent_ids=agent_ids,
            block_ids=block_ids,
            properties=properties,
            request_options=request_options,
        )
        return _response.data

    def count(self, *, request_options: typing.Optional[RequestOptions] = None) -> int:
        """
        Get count of all identities for a user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        int
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.identities.count()
        """
        _response = self._raw_client.count(request_options=request_options)
        return _response.data

    def retrieve(self, identity_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Identity:
        """
        Parameters
        ----------
        identity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Identity
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.identities.retrieve(
            identity_id="identity_id",
        )
        """
        _response = self._raw_client.retrieve(identity_id, request_options=request_options)
        return _response.data

    def delete(
        self, identity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete an identity by its identifier key

        Parameters
        ----------
        identity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.identities.delete(
            identity_id="identity_id",
        )
        """
        _response = self._raw_client.delete(identity_id, request_options=request_options)
        return _response.data

    def modify(
        self,
        identity_id: str,
        *,
        identifier_key: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        identity_type: typing.Optional[IdentityType] = OMIT,
        agent_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        block_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        properties: typing.Optional[typing.Sequence[IdentityProperty]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Identity:
        """
        Parameters
        ----------
        identity_id : str

        identifier_key : typing.Optional[str]
            External, user-generated identifier key of the identity.

        name : typing.Optional[str]
            The name of the identity.

        identity_type : typing.Optional[IdentityType]
            The type of the identity.

        agent_ids : typing.Optional[typing.Sequence[str]]
            The agent ids that are associated with the identity.

        block_ids : typing.Optional[typing.Sequence[str]]
            The IDs of the blocks associated with the identity.

        properties : typing.Optional[typing.Sequence[IdentityProperty]]
            List of properties associated with the identity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Identity
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.identities.modify(
            identity_id="identity_id",
        )
        """
        _response = self._raw_client.modify(
            identity_id,
            identifier_key=identifier_key,
            name=name,
            identity_type=identity_type,
            agent_ids=agent_ids,
            block_ids=block_ids,
            properties=properties,
            request_options=request_options,
        )
        return _response.data


class AsyncIdentitiesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIdentitiesClient(client_wrapper=client_wrapper)
        self.properties = AsyncPropertiesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIdentitiesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIdentitiesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        name: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        identifier_key: typing.Optional[str] = None,
        identity_type: typing.Optional[IdentityType] = None,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Identity]:
        """
        Get a list of all identities in the database

        Parameters
        ----------
        name : typing.Optional[str]

        project_id : typing.Optional[str]

        identifier_key : typing.Optional[str]

        identity_type : typing.Optional[IdentityType]

        before : typing.Optional[str]

        after : typing.Optional[str]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Identity]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.identities.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            name=name,
            project_id=project_id,
            identifier_key=identifier_key,
            identity_type=identity_type,
            before=before,
            after=after,
            limit=limit,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        identifier_key: str,
        name: str,
        identity_type: IdentityType,
        project_id: typing.Optional[str] = OMIT,
        agent_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        block_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        properties: typing.Optional[typing.Sequence[IdentityProperty]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Identity:
        """
        Parameters
        ----------
        identifier_key : str
            External, user-generated identifier key of the identity.

        name : str
            The name of the identity.

        identity_type : IdentityType
            The type of the identity.

        project_id : typing.Optional[str]
            The project id of the identity, if applicable.

        agent_ids : typing.Optional[typing.Sequence[str]]
            The agent ids that are associated with the identity.

        block_ids : typing.Optional[typing.Sequence[str]]
            The IDs of the blocks associated with the identity.

        properties : typing.Optional[typing.Sequence[IdentityProperty]]
            List of properties associated with the identity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Identity
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.identities.create(
                identifier_key="identifier_key",
                name="name",
                identity_type="org",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            identifier_key=identifier_key,
            name=name,
            identity_type=identity_type,
            project_id=project_id,
            agent_ids=agent_ids,
            block_ids=block_ids,
            properties=properties,
            request_options=request_options,
        )
        return _response.data

    async def upsert(
        self,
        *,
        identifier_key: str,
        name: str,
        identity_type: IdentityType,
        project_id: typing.Optional[str] = OMIT,
        agent_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        block_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        properties: typing.Optional[typing.Sequence[IdentityProperty]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Identity:
        """
        Parameters
        ----------
        identifier_key : str
            External, user-generated identifier key of the identity.

        name : str
            The name of the identity.

        identity_type : IdentityType
            The type of the identity.

        project_id : typing.Optional[str]
            The project id of the identity, if applicable.

        agent_ids : typing.Optional[typing.Sequence[str]]
            The agent ids that are associated with the identity.

        block_ids : typing.Optional[typing.Sequence[str]]
            The IDs of the blocks associated with the identity.

        properties : typing.Optional[typing.Sequence[IdentityProperty]]
            List of properties associated with the identity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Identity
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.identities.upsert(
                identifier_key="identifier_key",
                name="name",
                identity_type="org",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert(
            identifier_key=identifier_key,
            name=name,
            identity_type=identity_type,
            project_id=project_id,
            agent_ids=agent_ids,
            block_ids=block_ids,
            properties=properties,
            request_options=request_options,
        )
        return _response.data

    async def count(self, *, request_options: typing.Optional[RequestOptions] = None) -> int:
        """
        Get count of all identities for a user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        int
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.identities.count()


        asyncio.run(main())
        """
        _response = await self._raw_client.count(request_options=request_options)
        return _response.data

    async def retrieve(self, identity_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Identity:
        """
        Parameters
        ----------
        identity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Identity
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.identities.retrieve(
                identity_id="identity_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(identity_id, request_options=request_options)
        return _response.data

    async def delete(
        self, identity_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete an identity by its identifier key

        Parameters
        ----------
        identity_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.identities.delete(
                identity_id="identity_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(identity_id, request_options=request_options)
        return _response.data

    async def modify(
        self,
        identity_id: str,
        *,
        identifier_key: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        identity_type: typing.Optional[IdentityType] = OMIT,
        agent_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        block_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        properties: typing.Optional[typing.Sequence[IdentityProperty]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Identity:
        """
        Parameters
        ----------
        identity_id : str

        identifier_key : typing.Optional[str]
            External, user-generated identifier key of the identity.

        name : typing.Optional[str]
            The name of the identity.

        identity_type : typing.Optional[IdentityType]
            The type of the identity.

        agent_ids : typing.Optional[typing.Sequence[str]]
            The agent ids that are associated with the identity.

        block_ids : typing.Optional[typing.Sequence[str]]
            The IDs of the blocks associated with the identity.

        properties : typing.Optional[typing.Sequence[IdentityProperty]]
            List of properties associated with the identity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Identity
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.identities.modify(
                identity_id="identity_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.modify(
            identity_id,
            identifier_key=identifier_key,
            name=name,
            identity_type=identity_type,
            agent_ids=agent_ids,
            block_ids=block_ids,
            properties=properties,
            request_options=request_options,
        )
        return _response.data
