# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.letta_batch_messages import LettaBatchMessages
from .raw_client import AsyncRawMessagesClient, RawMessagesClient


class MessagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMessagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMessagesClient
        """
        return self._raw_client

    def list_batch_messages(
        self,
        batch_id: str,
        *,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        sort_descending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LettaBatchMessages:
        """
        Get messages for a specific batch job.

        Returns messages associated with the batch in chronological order.

        Pagination:
        - For the first page, omit the cursor parameter
        - For subsequent pages, use the ID of the last message from the previous response as the cursor
        - Results will include messages before/after the cursor based on sort_descending

        Parameters
        ----------
        batch_id : str

        limit : typing.Optional[int]
            Maximum number of messages to return

        cursor : typing.Optional[str]
            Message ID to use as pagination cursor (get messages before/after this ID) depending on sort_descending.

        agent_id : typing.Optional[str]
            Filter messages by agent ID

        sort_descending : typing.Optional[bool]
            Sort messages by creation time (true=newest first)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LettaBatchMessages
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.messages.list_batch_messages(
            batch_id="batch_id",
        )
        """
        _response = self._raw_client.list_batch_messages(
            batch_id,
            limit=limit,
            cursor=cursor,
            agent_id=agent_id,
            sort_descending=sort_descending,
            request_options=request_options,
        )
        return _response.data


class AsyncMessagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMessagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMessagesClient
        """
        return self._raw_client

    async def list_batch_messages(
        self,
        batch_id: str,
        *,
        limit: typing.Optional[int] = None,
        cursor: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        sort_descending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LettaBatchMessages:
        """
        Get messages for a specific batch job.

        Returns messages associated with the batch in chronological order.

        Pagination:
        - For the first page, omit the cursor parameter
        - For subsequent pages, use the ID of the last message from the previous response as the cursor
        - Results will include messages before/after the cursor based on sort_descending

        Parameters
        ----------
        batch_id : str

        limit : typing.Optional[int]
            Maximum number of messages to return

        cursor : typing.Optional[str]
            Message ID to use as pagination cursor (get messages before/after this ID) depending on sort_descending.

        agent_id : typing.Optional[str]
            Filter messages by agent ID

        sort_descending : typing.Optional[bool]
            Sort messages by creation time (true=newest first)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LettaBatchMessages
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.messages.list_batch_messages(
                batch_id="batch_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_batch_messages(
            batch_id,
            limit=limit,
            cursor=cursor,
            agent_id=agent_id,
            sort_descending=sort_descending,
            request_options=request_options,
        )
        return _response.data
