# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.llm_config import LlmConfig
from ..types.provider_category import ProviderCategory
from ..types.provider_type import ProviderType
from .raw_client import AsyncRawModelsClient, RawModelsClient


class ModelsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawModelsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawModelsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawModelsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        provider_category: typing.Optional[typing.Union[ProviderCategory, typing.Sequence[ProviderCategory]]] = None,
        provider_name: typing.Optional[str] = None,
        provider_type: typing.Optional[ProviderType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[LlmConfig]:
        """
        List available LLM models using the asynchronous implementation for improved performance

        Parameters
        ----------
        provider_category : typing.Optional[typing.Union[ProviderCategory, typing.Sequence[ProviderCategory]]]

        provider_name : typing.Optional[str]

        provider_type : typing.Optional[ProviderType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[LlmConfig]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.models.list()
        """
        _response = self._raw_client.list(
            provider_category=provider_category,
            provider_name=provider_name,
            provider_type=provider_type,
            request_options=request_options,
        )
        return _response.data

    def listembeddingmodels(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.models.listembeddingmodels()
        """
        _response = self._raw_client.listembeddingmodels(request_options=request_options)
        return _response.data


class AsyncModelsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawModelsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawModelsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawModelsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        provider_category: typing.Optional[typing.Union[ProviderCategory, typing.Sequence[ProviderCategory]]] = None,
        provider_name: typing.Optional[str] = None,
        provider_type: typing.Optional[ProviderType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[LlmConfig]:
        """
        List available LLM models using the asynchronous implementation for improved performance

        Parameters
        ----------
        provider_category : typing.Optional[typing.Union[ProviderCategory, typing.Sequence[ProviderCategory]]]

        provider_name : typing.Optional[str]

        provider_type : typing.Optional[ProviderType]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[LlmConfig]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.models.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            provider_category=provider_category,
            provider_name=provider_name,
            provider_type=provider_type,
            request_options=request_options,
        )
        return _response.data

    async def listembeddingmodels(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.models.listembeddingmodels()


        asyncio.run(main())
        """
        _response = await self._raw_client.listembeddingmodels(request_options=request_options)
        return _response.data
