# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.run import Run
from .messages.client import AsyncMessagesClient, MessagesClient
from .raw_client import AsyncRawRunsClient, RawRunsClient
from .steps.client import AsyncStepsClient, StepsClient
from .types.letta_streaming_response import LettaStreamingResponse
from .usage.client import AsyncUsageClient, UsageClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RunsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRunsClient(client_wrapper=client_wrapper)
        self.messages = MessagesClient(client_wrapper=client_wrapper)

        self.usage = UsageClient(client_wrapper=client_wrapper)

        self.steps = StepsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRunsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRunsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        agent_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        background: typing.Optional[bool] = None,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        ascending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Run]:
        """
        List all runs.

        Parameters
        ----------
        agent_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The unique identifier of the agent associated with the run.

        background : typing.Optional[bool]
            If True, filters for runs that were created in background mode.

        after : typing.Optional[str]
            Cursor for pagination

        before : typing.Optional[str]
            Cursor for pagination

        limit : typing.Optional[int]
            Maximum number of runs to return

        ascending : typing.Optional[bool]
            Whether to sort agents oldest to newest (True) or newest to oldest (False, default)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Run]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.list()
        """
        _response = self._raw_client.list(
            agent_ids=agent_ids,
            background=background,
            after=after,
            before=before,
            limit=limit,
            ascending=ascending,
            request_options=request_options,
        )
        return _response.data

    def list_active(
        self,
        *,
        agent_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        background: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Run]:
        """
        List all active runs.

        Parameters
        ----------
        agent_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The unique identifier of the agent associated with the run.

        background : typing.Optional[bool]
            If True, filters for runs that were created in background mode.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Run]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.list_active()
        """
        _response = self._raw_client.list_active(
            agent_ids=agent_ids, background=background, request_options=request_options
        )
        return _response.data

    def retrieve(self, run_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Run:
        """
        Get the status of a run.

        Parameters
        ----------
        run_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Run
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.retrieve(
            run_id="run_id",
        )
        """
        _response = self._raw_client.retrieve(run_id, request_options=request_options)
        return _response.data

    def delete(self, run_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Run:
        """
        Delete a run by its run_id.

        Parameters
        ----------
        run_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Run
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.delete(
            run_id="run_id",
        )
        """
        _response = self._raw_client.delete(run_id, request_options=request_options)
        return _response.data

    def stream(
        self,
        run_id: str,
        *,
        starting_after: typing.Optional[int] = OMIT,
        include_pings: typing.Optional[bool] = OMIT,
        poll_interval: typing.Optional[float] = OMIT,
        batch_size: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[LettaStreamingResponse]:
        """
        Parameters
        ----------
        run_id : str

        starting_after : typing.Optional[int]
            Sequence id to use as a cursor for pagination. Response will start streaming after this chunk sequence id

        include_pings : typing.Optional[bool]
            Whether to include periodic keepalive ping messages in the stream to prevent connection timeouts.

        poll_interval : typing.Optional[float]
            Seconds to wait between polls when no new data.

        batch_size : typing.Optional[int]
            Number of entries to read per batch.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.Iterator[LettaStreamingResponse]
            Successful response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        response = client.runs.stream(
            run_id="run_id",
        )
        for chunk in response:
            yield chunk
        """
        with self._raw_client.stream(
            run_id,
            starting_after=starting_after,
            include_pings=include_pings,
            poll_interval=poll_interval,
            batch_size=batch_size,
            request_options=request_options,
        ) as r:
            yield from r.data


class AsyncRunsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRunsClient(client_wrapper=client_wrapper)
        self.messages = AsyncMessagesClient(client_wrapper=client_wrapper)

        self.usage = AsyncUsageClient(client_wrapper=client_wrapper)

        self.steps = AsyncStepsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRunsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRunsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        agent_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        background: typing.Optional[bool] = None,
        after: typing.Optional[str] = None,
        before: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        ascending: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Run]:
        """
        List all runs.

        Parameters
        ----------
        agent_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The unique identifier of the agent associated with the run.

        background : typing.Optional[bool]
            If True, filters for runs that were created in background mode.

        after : typing.Optional[str]
            Cursor for pagination

        before : typing.Optional[str]
            Cursor for pagination

        limit : typing.Optional[int]
            Maximum number of runs to return

        ascending : typing.Optional[bool]
            Whether to sort agents oldest to newest (True) or newest to oldest (False, default)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Run]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            agent_ids=agent_ids,
            background=background,
            after=after,
            before=before,
            limit=limit,
            ascending=ascending,
            request_options=request_options,
        )
        return _response.data

    async def list_active(
        self,
        *,
        agent_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        background: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Run]:
        """
        List all active runs.

        Parameters
        ----------
        agent_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            The unique identifier of the agent associated with the run.

        background : typing.Optional[bool]
            If True, filters for runs that were created in background mode.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Run]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.list_active()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_active(
            agent_ids=agent_ids, background=background, request_options=request_options
        )
        return _response.data

    async def retrieve(self, run_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Run:
        """
        Get the status of a run.

        Parameters
        ----------
        run_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Run
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.retrieve(
                run_id="run_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(run_id, request_options=request_options)
        return _response.data

    async def delete(self, run_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Run:
        """
        Delete a run by its run_id.

        Parameters
        ----------
        run_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Run
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.delete(
                run_id="run_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(run_id, request_options=request_options)
        return _response.data

    async def stream(
        self,
        run_id: str,
        *,
        starting_after: typing.Optional[int] = OMIT,
        include_pings: typing.Optional[bool] = OMIT,
        poll_interval: typing.Optional[float] = OMIT,
        batch_size: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[LettaStreamingResponse]:
        """
        Parameters
        ----------
        run_id : str

        starting_after : typing.Optional[int]
            Sequence id to use as a cursor for pagination. Response will start streaming after this chunk sequence id

        include_pings : typing.Optional[bool]
            Whether to include periodic keepalive ping messages in the stream to prevent connection timeouts.

        poll_interval : typing.Optional[float]
            Seconds to wait between polls when no new data.

        batch_size : typing.Optional[int]
            Number of entries to read per batch.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Yields
        ------
        typing.AsyncIterator[LettaStreamingResponse]
            Successful response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.runs.stream(
                run_id="run_id",
            )
            async for chunk in response:
                yield chunk


        asyncio.run(main())
        """
        async with self._raw_client.stream(
            run_id,
            starting_after=starting_after,
            include_pings=include_pings,
            poll_interval=poll_interval,
            batch_size=batch_size,
            request_options=request_options,
        ) as r:
            async for _chunk in r.data:
                yield _chunk
