# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.step import Step
from .raw_client import AsyncRawStepsClient, RawStepsClient


class StepsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawStepsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawStepsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawStepsClient
        """
        return self._raw_client

    def list(
        self,
        run_id: str,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Step]:
        """
        Get messages associated with a run with filtering options.

        Args:
            run_id: ID of the run
            before: A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, starting with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
            after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
            limit: Maximum number of steps to return
            order: Sort order by the created_at timestamp of the objects. asc for ascending order and desc for descending order.

        Returns:
            A list of steps associated with the run.

        Parameters
        ----------
        run_id : str

        before : typing.Optional[str]
            Cursor for pagination

        after : typing.Optional[str]
            Cursor for pagination

        limit : typing.Optional[int]
            Maximum number of messages to return

        order : typing.Optional[str]
            Sort order by the created_at timestamp of the objects. asc for ascending order and desc for descending order.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Step]
            Successful Response

        Examples
        --------
        from letta_client import Letta

        client = Letta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )
        client.runs.steps.list(
            run_id="run_id",
        )
        """
        _response = self._raw_client.list(
            run_id, before=before, after=after, limit=limit, order=order, request_options=request_options
        )
        return _response.data


class AsyncStepsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawStepsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawStepsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawStepsClient
        """
        return self._raw_client

    async def list(
        self,
        run_id: str,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[Step]:
        """
        Get messages associated with a run with filtering options.

        Args:
            run_id: ID of the run
            before: A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, starting with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
            after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
            limit: Maximum number of steps to return
            order: Sort order by the created_at timestamp of the objects. asc for ascending order and desc for descending order.

        Returns:
            A list of steps associated with the run.

        Parameters
        ----------
        run_id : str

        before : typing.Optional[str]
            Cursor for pagination

        after : typing.Optional[str]
            Cursor for pagination

        limit : typing.Optional[int]
            Maximum number of messages to return

        order : typing.Optional[str]
            Sort order by the created_at timestamp of the objects. asc for ascending order and desc for descending order.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[Step]
            Successful Response

        Examples
        --------
        import asyncio

        from letta_client import AsyncLetta

        client = AsyncLetta(
            project="YOUR_PROJECT",
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.runs.steps.list(
                run_id="run_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            run_id, before=before, after=after, limit=limit, order=order, request_options=request_options
        )
        return _response.data
