# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.step import Step
from ..types.step_metrics import StepMetrics
from .types.steps_list_request_feedback import StepsListRequestFeedback


class RawStepsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[str] = None,
        start_date: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        model: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        trace_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        feedback: typing.Optional[StepsListRequestFeedback] = None,
        has_feedback: typing.Optional[bool] = None,
        tags: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[Step]]:
        """
        List steps with optional pagination and date filters.
        Dates should be provided in ISO 8601 format (e.g. 2025-01-29T15:01:19-08:00)

        Parameters
        ----------
        before : typing.Optional[str]
            Return steps before this step ID

        after : typing.Optional[str]
            Return steps after this step ID

        limit : typing.Optional[int]
            Maximum number of steps to return

        order : typing.Optional[str]
            Sort order (asc or desc)

        start_date : typing.Optional[str]
            Return steps after this ISO datetime (e.g. "2025-01-29T15:01:19-08:00")

        end_date : typing.Optional[str]
            Return steps before this ISO datetime (e.g. "2025-01-29T15:01:19-08:00")

        model : typing.Optional[str]
            Filter by the name of the model used for the step

        agent_id : typing.Optional[str]
            Filter by the ID of the agent that performed the step

        trace_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter by trace ids returned by the server

        feedback : typing.Optional[StepsListRequestFeedback]
            Filter by feedback

        has_feedback : typing.Optional[bool]
            Filter by whether steps have feedback (true) or not (false)

        tags : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter by tags

        project_id : typing.Optional[str]
            Filter by the project ID that is associated with the step (cloud only).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Step]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/steps/",
            method="GET",
            params={
                "before": before,
                "after": after,
                "limit": limit,
                "order": order,
                "start_date": start_date,
                "end_date": end_date,
                "model": model,
                "agent_id": agent_id,
                "trace_ids": trace_ids,
                "feedback": feedback,
                "has_feedback": has_feedback,
                "tags": tags,
                "project_id": project_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Step],
                    construct_type(
                        type_=typing.List[Step],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve(self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Step]:
        """
        Get a step by ID.

        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Step]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/steps/{jsonable_encoder(step_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Step,
                    construct_type(
                        type_=Step,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def retrieve_step_metrics(
        self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[StepMetrics]:
        """
        Get step metrics by step ID.

        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[StepMetrics]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/steps/{jsonable_encoder(step_id)}/metrics",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    StepMetrics,
                    construct_type(
                        type_=StepMetrics,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawStepsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        before: typing.Optional[str] = None,
        after: typing.Optional[str] = None,
        limit: typing.Optional[int] = None,
        order: typing.Optional[str] = None,
        start_date: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        model: typing.Optional[str] = None,
        agent_id: typing.Optional[str] = None,
        trace_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        feedback: typing.Optional[StepsListRequestFeedback] = None,
        has_feedback: typing.Optional[bool] = None,
        tags: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[Step]]:
        """
        List steps with optional pagination and date filters.
        Dates should be provided in ISO 8601 format (e.g. 2025-01-29T15:01:19-08:00)

        Parameters
        ----------
        before : typing.Optional[str]
            Return steps before this step ID

        after : typing.Optional[str]
            Return steps after this step ID

        limit : typing.Optional[int]
            Maximum number of steps to return

        order : typing.Optional[str]
            Sort order (asc or desc)

        start_date : typing.Optional[str]
            Return steps after this ISO datetime (e.g. "2025-01-29T15:01:19-08:00")

        end_date : typing.Optional[str]
            Return steps before this ISO datetime (e.g. "2025-01-29T15:01:19-08:00")

        model : typing.Optional[str]
            Filter by the name of the model used for the step

        agent_id : typing.Optional[str]
            Filter by the ID of the agent that performed the step

        trace_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter by trace ids returned by the server

        feedback : typing.Optional[StepsListRequestFeedback]
            Filter by feedback

        has_feedback : typing.Optional[bool]
            Filter by whether steps have feedback (true) or not (false)

        tags : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter by tags

        project_id : typing.Optional[str]
            Filter by the project ID that is associated with the step (cloud only).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Step]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/steps/",
            method="GET",
            params={
                "before": before,
                "after": after,
                "limit": limit,
                "order": order,
                "start_date": start_date,
                "end_date": end_date,
                "model": model,
                "agent_id": agent_id,
                "trace_ids": trace_ids,
                "feedback": feedback,
                "has_feedback": has_feedback,
                "tags": tags,
                "project_id": project_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Step],
                    construct_type(
                        type_=typing.List[Step],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve(
        self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Step]:
        """
        Get a step by ID.

        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Step]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/steps/{jsonable_encoder(step_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Step,
                    construct_type(
                        type_=Step,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def retrieve_step_metrics(
        self, step_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[StepMetrics]:
        """
        Get step metrics by step ID.

        Parameters
        ----------
        step_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[StepMetrics]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/steps/{jsonable_encoder(step_id)}/metrics",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    StepMetrics,
                    construct_type(
                        type_=StepMetrics,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        construct_type(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
