# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .action_parameters_model import ActionParametersModel
from .action_response_model import ActionResponseModel


class ActionModel(UncheckedBaseModel):
    """
    Action data model.
    """

    name: str
    description: str
    parameters: ActionParametersModel
    response: ActionResponseModel
    app_name: typing_extensions.Annotated[str, FieldMetadata(alias="appName")]
    app_id: typing_extensions.Annotated[str, FieldMetadata(alias="appId")]
    version: str
    available_versions: typing.List[str]
    tags: typing.List[str]
    logo: typing.Optional[str] = None
    display_name: typing.Optional[str] = None
    enabled: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
