# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class Block(UncheckedBaseModel):
    """
    A Block represents a reserved section of the LLM's context window which is editable. `Block` objects contained in the `Memory` object, which is able to edit the Block values.

    Parameters:
        label (str): The label of the block (e.g. 'human', 'persona'). This defines a category for the block.
        value (str): The value of the block. This is the string that is represented in the context window.
        limit (int): The character limit of the block.
        is_template (bool): Whether the block is a template (e.g. saved human/persona options). Non-template blocks are not stored in the database and are ephemeral, while templated blocks are stored in the database.
        label (str): The label of the block (e.g. 'human', 'persona'). This defines a category for the block.
        template_name (str): The name of the block template (if it is a template).
        description (str): Description of the block.
        metadata (Dict): Metadata of the block.
        user_id (str): The unique identifier of the user associated with the block.
    """

    value: str = pydantic.Field()
    """
    Value of the block.
    """

    limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Character limit of the block.
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The associated project id.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the template.
    """

    is_template: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the block is a template (e.g. saved human/persona options).
    """

    base_template_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The base template id of the block.
    """

    deployment_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the deployment.
    """

    entity_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the entity within the template.
    """

    preserve_on_migration: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Preserve the block on template migration.
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    Label of the block (e.g. 'human', 'persona') in the context window.
    """

    read_only: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the agent has read-only access to the block.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the block.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Metadata of the block.
    """

    hidden: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If set to True, the block will be hidden.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-friendly ID of the Block
    """

    created_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that made this Block.
    """

    last_updated_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the user that last updated this Block.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
