# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class CreateBlock(UncheckedBaseModel):
    """
    Create a block
    """

    value: str = pydantic.Field()
    """
    Value of the block.
    """

    limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Character limit of the block.
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The associated project id.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the template.
    """

    is_template: typing.Optional[bool] = None
    base_template_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The base template id of the block.
    """

    deployment_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the deployment.
    """

    entity_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the entity within the template.
    """

    preserve_on_migration: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Preserve the block on template migration.
    """

    label: str = pydantic.Field()
    """
    Label of the block.
    """

    read_only: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the agent has read-only access to the block.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the block.
    """

    metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Metadata of the block.
    """

    hidden: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If set to True, the block will be hidden.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
