# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class FileAgentSchema(UncheckedBaseModel):
    """
    File-Agent relationship with human-readable ID for agent file
    """

    agent_id: str = pydantic.Field()
    """
    Unique identifier of the agent.
    """

    file_id: str = pydantic.Field()
    """
    Unique identifier of the file.
    """

    source_id: str = pydantic.Field()
    """
    Unique identifier of the source.
    """

    file_name: str = pydantic.Field()
    """
    Name of the file.
    """

    is_open: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the agent currently has the file open.
    """

    visible_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Portion of the file the agent is focused on (may be large).
    """

    last_accessed_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    UTC timestamp of the agent's most recent access to this file.
    """

    start_line: typing.Optional[int] = pydantic.Field(default=None)
    """
    Starting line number (1-indexed) when file was opened with line range.
    """

    end_line: typing.Optional[int] = pydantic.Field(default=None)
    """
    Ending line number (exclusive) when file was opened with line range.
    """

    id: str = pydantic.Field()
    """
    Human-readable identifier for this file-agent relationship in the file
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
