# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .chat_completion_message_function_tool_call_input import ChatCompletionMessageFunctionToolCallInput
from .letta_schemas_agent_file_message_schema_content import LettaSchemasAgentFileMessageSchemaContent
from .message_role import MessageRole
from .tool_return import ToolReturn


class LettaSchemasAgentFileMessageSchema(UncheckedBaseModel):
    """
    Message with human-readable ID for agent file
    """

    type: typing.Optional[typing.Literal["message"]] = pydantic.Field(default=None)
    """
    The message type to be created.
    """

    role: MessageRole = pydantic.Field()
    """
    The role of the participant.
    """

    content: LettaSchemasAgentFileMessageSchemaContent = pydantic.Field()
    """
    The content of the message.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the participant.
    """

    otid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The offline threading id associated with this message
    """

    sender_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the sender of the message, can be an identity id or agent id
    """

    batch_item_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the LLMBatchItem that this message is associated with
    """

    group_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The multi-agent group that the message was sent in
    """

    id: str = pydantic.Field()
    """
    Human-readable identifier for this message in the file
    """

    model: typing.Optional[str] = pydantic.Field(default=None)
    """
    The model used to make the function call
    """

    agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the agent
    """

    tool_calls: typing.Optional[typing.List[ChatCompletionMessageFunctionToolCallInput]] = pydantic.Field(default=None)
    """
    The list of tool calls requested. Only applicable for role assistant.
    """

    tool_call_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the tool call. Only applicable for role tool.
    """

    tool_returns: typing.Optional[typing.List[ToolReturn]] = pydantic.Field(default=None)
    """
    Tool execution return information for prior tool calls
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the object was created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
