# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class McpToolHealth(UncheckedBaseModel):
    """
    Health status for an MCP tool's schema.
    """

    status: str = pydantic.Field()
    """
    Schema health status: STRICT_COMPLIANT, NON_STRICT_ONLY, or INVALID
    """

    reasons: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of reasons for the health status
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
