# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .npm_requirement import NpmRequirement
from .pip_requirement import PipRequirement


class ToolCreate(UncheckedBaseModel):
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the tool.
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Metadata tags.
    """

    source_code: str = pydantic.Field()
    """
    The source code of the function.
    """

    source_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The source type of the function.
    """

    json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The JSON schema of the function (auto-generated from source_code if not provided)
    """

    args_json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The args JSON schema of the function.
    """

    return_char_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of characters in the response.
    """

    pip_requirements: typing.Optional[typing.List[PipRequirement]] = pydantic.Field(default=None)
    """
    Optional list of pip packages required by this tool.
    """

    npm_requirements: typing.Optional[typing.List[NpmRequirement]] = pydantic.Field(default=None)
    """
    Optional list of npm packages required by this tool.
    """

    default_requires_approval: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not to require approval before executing this tool.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
