import os
from enum import Enum
from typing import List

import yaml


class ExceptionMessageKey(Enum):
    CLASSMETHOD_REQUIRED_MSG = "CLASSMETHOD_REQUIRED_MSG"
    CLASSMETHOD_REQUIRED_NOTES = "CLASSMETHOD_REQUIRED_NOTES"
    CONNECTED_NODES_EMPTY_MSG = "CONNECTED_NODES_EMPTY_MSG"
    CONNECTED_NODES_EMPTY_NOTES = "CONNECTED_NODES_EMPTY_NOTES"
    CONNECTED_NODES_TYPE_MSG = "CONNECTED_NODES_TYPE_MSG"
    CONNECTED_NODES_TYPE_NOTES = "CONNECTED_NODES_TYPE_NOTES"
    DICT_PARAMETER_NOT_ALLOWED_MSG = "DICT_PARAMETER_NOT_ALLOWED_MSG"
    DICT_PARAMETER_NOT_ALLOWED_NOTES = "DICT_PARAMETER_NOT_ALLOWED_NOTES"
    DUPLICATE_PARAMETER_NAMES_MSG = "DUPLICATE_PARAMETER_NAMES_MSG"
    DUPLICATE_PARAMETER_NAMES_NOTES = "DUPLICATE_PARAMETER_NAMES_NOTES"
    INVALID_SYSTEM_MESSAGE_MSG = "INVALID_SYSTEM_MESSAGE_MSG"
    INVALID_SESSION_FILE_NAME_WARN = "INVALID_SESSION_FILE_NAME_WARN"
    MAX_TOOL_CALLS_NEGATIVE_MSG = "MAX_TOOL_CALLS_NEGATIVE_MSG"
    MAX_TOOL_CALLS_NEGATIVE_NOTES = "MAX_TOOL_CALLS_NEGATIVE_NOTES"
    MAX_TOOL_CALLS_UNLIMITED_WARN = "MAX_TOOL_CALLS_UNLIMITED_WARN"
    MESSAGE_HISTORY_EMPTY_MSG = "MESSAGE_HISTORY_EMPTY_MSG"
    MESSAGE_HISTORY_EMPTY_NOTES = "MESSAGE_HISTORY_EMPTY_NOTES"
    MESSAGE_HISTORY_TYPE_MSG = "MESSAGE_HISTORY_TYPE_MSG"
    MESSAGE_HISTORY_TYPE_NOTES = "MESSAGE_HISTORY_TYPE_NOTES"
    MISSING_PRETTY_NAME_MSG = "MISSING_PRETTY_NAME_MSG"
    MISSING_TOOL_DETAILS_MSG = "MISSING_TOOL_DETAILS_MSG"
    MISSING_TOOL_DETAILS_NOTES = "MISSING_TOOL_DETAILS_NOTES"
    MODEL_REQUIRED_MSG = "MODEL_REQUIRED_MSG"
    MODEL_REQUIRED_NOTES = "MODEL_REQUIRED_NOTES"
    NO_SYSTEM_MESSAGE_WARN = "NO_SYSTEM_MESSAGE_WARN"
    ONLY_SYSTEM_MESSAGE_WARN = "ONLY_SYSTEM_MESSAGE_WARN"
    OUTPUT_MODEL_EMPTY_MSG = "OUTPUT_MODEL_EMPTY_MSG"
    OUTPUT_MODEL_EMPTY_NOTES = "OUTPUT_MODEL_EMPTY_NOTES"
    OUTPUT_MODEL_REQUIRED_MSG = "OUTPUT_MODEL_REQUIRED_MSG"
    OUTPUT_MODEL_REQUIRED_NOTES = "OUTPUT_MODEL_REQUIRED_NOTES"
    OUTPUT_MODEL_TYPE_MSG = "OUTPUT_MODEL_TYPE_MSG"
    OUTPUT_MODEL_TYPE_NOTES = "OUTPUT_MODEL_TYPE_NOTES"
    PARAMETER_SET_CONTAINS_INVALID_TYPE_MSG = "PARAMETER_SET_CONTAINS_INVALID_TYPE_MSG"
    PARAMETER_SET_CONTAINS_INVALID_TYPE_NOTES = (
        "PARAMETER_SET_CONTAINS_INVALID_TYPE_NOTES"
    )
    TOOL_PARAMETERS_FROM_SCHEMA_FAILED_MSG = "TOOL_PARAMETERS_FROM_SCHEMA_FAILED_MSG"
    TOOL_PARAMETERS_TYPE_MSG = "TOOL_PARAMETERS_TYPE_MSG"
    TOOL_PARAMETERS_TYPE_NOTES = "TOOL_PARAMETERS_TYPE_NOTES"


_yaml_path = os.path.join(os.path.dirname(__file__), "exception_messages.yaml")
with open(_yaml_path, "r", encoding="utf-8") as f:
    _messages = yaml.safe_load(f)


def get_message(key: str | ExceptionMessageKey) -> str:
    if isinstance(key, ExceptionMessageKey):
        key = key.value
    return _messages[key]


def get_notes(key: str | ExceptionMessageKey) -> str | List[str]:
    """
    Gets the notes for a given message key.

    The return type can either be a single string or a list of string
    """
    if isinstance(key, ExceptionMessageKey):
        key = key.value
    return _messages[key]
